/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.jce.provider;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import shaded.cfca.sadk.org.bouncycastle.jce.X509LDAPCertStoreParameters;
import shaded.cfca.sadk.org.bouncycastle.util.Selector;
import shaded.cfca.sadk.org.bouncycastle.util.StoreException;
import shaded.cfca.sadk.org.bouncycastle.x509.X509CertPairStoreSelector;
import shaded.cfca.sadk.org.bouncycastle.x509.X509CertStoreSelector;
import shaded.cfca.sadk.org.bouncycastle.x509.X509CertificatePair;
import shaded.cfca.sadk.org.bouncycastle.x509.X509StoreParameters;
import shaded.cfca.sadk.org.bouncycastle.x509.X509StoreSpi;
import shaded.cfca.sadk.org.bouncycastle.x509.util.LDAPStoreHelper;

public class X509StoreLDAPCerts
extends X509StoreSpi {
    private LDAPStoreHelper helper;

    public void engineInit(X509StoreParameters params) {
        if (!(params instanceof X509LDAPCertStoreParameters)) {
            throw new IllegalArgumentException("Initialization parameters must be an instance of " + X509LDAPCertStoreParameters.class.getName() + ".");
        }
        this.helper = new LDAPStoreHelper((X509LDAPCertStoreParameters)params);
    }

    public Collection engineGetMatches(Selector selector) throws StoreException {
        if (!(selector instanceof X509CertStoreSelector)) {
            return Collections.EMPTY_SET;
        }
        X509CertStoreSelector xselector = (X509CertStoreSelector)selector;
        HashSet set = new HashSet();
        if (xselector.getBasicConstraints() > 0) {
            set.addAll(this.helper.getCACertificates(xselector));
            set.addAll(this.getCertificatesFromCrossCertificatePairs(xselector));
        } else if (xselector.getBasicConstraints() == -2) {
            set.addAll(this.helper.getUserCertificates(xselector));
        } else {
            set.addAll(this.helper.getUserCertificates(xselector));
            set.addAll(this.helper.getCACertificates(xselector));
            set.addAll(this.getCertificatesFromCrossCertificatePairs(xselector));
        }
        return set;
    }

    private Collection getCertificatesFromCrossCertificatePairs(X509CertStoreSelector xselector) throws StoreException {
        HashSet set = new HashSet();
        X509CertPairStoreSelector ps = new X509CertPairStoreSelector();
        ps.setForwardSelector(xselector);
        ps.setReverseSelector(new X509CertStoreSelector());
        HashSet crossCerts = new HashSet(this.helper.getCrossCertificatePairs(ps));
        HashSet<X509Certificate> forward = new HashSet<X509Certificate>();
        HashSet<X509Certificate> reverse = new HashSet<X509Certificate>();
        Iterator it = crossCerts.iterator();
        while (it.hasNext()) {
            X509CertificatePair pair = (X509CertificatePair)it.next();
            if (pair.getForward() != null) {
                forward.add(pair.getForward());
            }
            if (pair.getReverse() == null) continue;
            reverse.add(pair.getReverse());
        }
        set.addAll(forward);
        set.addAll(reverse);
        return set;
    }
}

