/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.eac.test;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import shaded.cfca.sadk.org.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import shaded.cfca.sadk.org.bouncycastle.asn1.eac.CertificateHolderReference;
import shaded.cfca.sadk.org.bouncycastle.asn1.eac.CertificationAuthorityReference;
import shaded.cfca.sadk.org.bouncycastle.asn1.eac.EACObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.eac.PackedDate;
import shaded.cfca.sadk.org.bouncycastle.eac.EACCertificateBuilder;
import shaded.cfca.sadk.org.bouncycastle.eac.EACCertificateHolder;
import shaded.cfca.sadk.org.bouncycastle.eac.EACCertificateRequestHolder;
import shaded.cfca.sadk.org.bouncycastle.eac.jcajce.JcaPublicKeyConverter;
import shaded.cfca.sadk.org.bouncycastle.eac.operator.EACSignatureVerifier;
import shaded.cfca.sadk.org.bouncycastle.eac.operator.EACSigner;
import shaded.cfca.sadk.org.bouncycastle.eac.operator.jcajce.JcaEACSignatureVerifierBuilder;
import shaded.cfca.sadk.org.bouncycastle.eac.operator.jcajce.JcaEACSignerBuilder;
import shaded.cfca.sadk.org.bouncycastle.eac.test.EACTestSetup;
import shaded.cfca.sadk.org.bouncycastle.jce.ECNamedCurveTable;
import shaded.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import shaded.cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import shaded.cfca.sadk.org.bouncycastle.util.io.Streams;

public class AllTests
extends TestCase {
    private static final String BC = "BC";

    public void setUp() {
        if (Security.getProvider(BC) != null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public void testLoadCertificate() throws Exception {
        EACCertificateHolder certHolder = new EACCertificateHolder(this.getInput("Belgique CVCA-02032010.7816.cvcert"));
        PublicKey pubKey = new JcaPublicKeyConverter().setProvider(BC).getKey(certHolder.getPublicKeyDataObject());
        EACSignatureVerifier verifier = new JcaEACSignatureVerifierBuilder().build(certHolder.getPublicKeyDataObject().getUsage(), pubKey);
        if (!certHolder.isSignatureValid(verifier)) {
            AllTests.fail((String)"signature test failed");
        }
    }

    private byte[] getInput(String name) throws IOException {
        return Streams.readAll(((Object)((Object)this)).getClass().getResourceAsStream(name));
    }

    public void testLoadInvalidRequest() throws Exception {
        EACCertificateRequestHolder requestHolder = new EACCertificateRequestHolder(this.getInput("REQ_18102010.csr"));
        PublicKey pubKey = new JcaPublicKeyConverter().setProvider(BC).getKey(requestHolder.getPublicKeyDataObject());
        EACSignatureVerifier verifier = new JcaEACSignatureVerifierBuilder().build(requestHolder.getPublicKeyDataObject().getUsage(), pubKey);
        if (requestHolder.isInnerSignatureValid(verifier)) {
            AllTests.fail((String)"signature test failed");
        }
    }

    public void testLoadRefCert() throws Exception {
        EACCertificateHolder certHolder = new EACCertificateHolder(this.getInput("at_cert_19a.cvcert"));
    }

    public void testGenerateEC() throws Exception {
        EACSignatureVerifier verifier;
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec("prime256v1");
        KeyPair kp = this.generateECKeyPair(ecSpec);
        JcaEACSignerBuilder signerBuilder = new JcaEACSignerBuilder().setProvider(BC);
        EACSigner signer = signerBuilder.build("SHA256withECDSA", kp.getPrivate());
        int role = 192;
        int rights = 3;
        EACCertificateBuilder certBuilder = new EACCertificateBuilder(new CertificationAuthorityReference("AU", "BC TEST", "12345"), new JcaPublicKeyConverter().getPublicKeyDataObject(signer.getUsageIdentifier(), kp.getPublic()), new CertificateHolderReference("AU", "BC TEST", "12345"), new CertificateHolderAuthorization(EACObjectIdentifiers.id_EAC_ePassport, role | rights), new PackedDate("110101"), new PackedDate("120101"));
        EACCertificateHolder certHolder = certBuilder.build(signer);
        if (!certHolder.isSignatureValid(verifier = new JcaEACSignatureVerifierBuilder().build(certHolder.getPublicKeyDataObject().getUsage(), kp.getPublic()))) {
            AllTests.fail((String)"first signature test failed");
        }
        PublicKey pubKey = new JcaPublicKeyConverter().setProvider(BC).getKey(certHolder.getPublicKeyDataObject());
        verifier = new JcaEACSignatureVerifierBuilder().build(certHolder.getPublicKeyDataObject().getUsage(), pubKey);
        if (!certHolder.isSignatureValid(verifier)) {
            AllTests.fail((String)"second signature test failed");
        }
    }

    public void testGenerateRSA() throws Exception {
        EACSignatureVerifier verifier;
        KeyPair kp = this.generateRSAKeyPair();
        JcaEACSignerBuilder signerBuilder = new JcaEACSignerBuilder().setProvider(BC);
        EACSigner signer = signerBuilder.build("SHA256withRSA", kp.getPrivate());
        int role = 192;
        int rights = 3;
        EACCertificateBuilder certBuilder = new EACCertificateBuilder(new CertificationAuthorityReference("AU", "BC TEST", "12345"), new JcaPublicKeyConverter().getPublicKeyDataObject(signer.getUsageIdentifier(), kp.getPublic()), new CertificateHolderReference("AU", "BC TEST", "12345"), new CertificateHolderAuthorization(EACObjectIdentifiers.id_EAC_ePassport, role | rights), new PackedDate("110101"), new PackedDate("120101"));
        EACCertificateHolder certHolder = certBuilder.build(signer);
        if (!certHolder.isSignatureValid(verifier = new JcaEACSignatureVerifierBuilder().build(certHolder.getPublicKeyDataObject().getUsage(), kp.getPublic()))) {
            AllTests.fail((String)"first signature test failed");
        }
        PublicKey pubKey = new JcaPublicKeyConverter().setProvider(BC).getKey(certHolder.getPublicKeyDataObject());
        verifier = new JcaEACSignatureVerifierBuilder().build(certHolder.getPublicKeyDataObject().getUsage(), pubKey);
        if (!certHolder.isSignatureValid(verifier)) {
            AllTests.fail((String)"second signature test failed");
        }
    }

    private KeyPair generateECKeyPair(ECParameterSpec spec) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("ECDSA", BC);
        gen.initialize(spec, new SecureRandom());
        KeyPair generatedKeyPair = gen.generateKeyPair();
        return generatedKeyPair;
    }

    private KeyPair generateRSAKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA", BC);
        gen.initialize(1024, new SecureRandom());
        KeyPair generatedKeyPair = gen.generateKeyPair();
        return generatedKeyPair;
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        TestRunner.run((Test)AllTests.suite());
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite("EAC tests");
        suite.addTestSuite(AllTests.class);
        return new EACTestSetup((Test)suite);
    }
}

