/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.dvcs;

import shaded.cfca.sadk.org.bouncycastle.asn1.dvcs.Data;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSException;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSSignedData;
import shaded.cfca.sadk.org.bouncycastle.dvcs.DVCSConstructionException;
import shaded.cfca.sadk.org.bouncycastle.dvcs.DVCSRequestData;

public class VSDRequestData
extends DVCSRequestData {
    private CMSSignedData doc;

    VSDRequestData(Data data) throws DVCSConstructionException {
        super(data);
        this.initDocument();
    }

    private void initDocument() throws DVCSConstructionException {
        if (this.doc == null) {
            if (this.data.getMessage() == null) {
                throw new DVCSConstructionException("DVCSRequest.data.message should be specified for VSD service");
            }
            try {
                this.doc = new CMSSignedData(this.data.getMessage().getOctets());
            }
            catch (CMSException e) {
                throw new DVCSConstructionException("Can't read CMS SignedData from input", e);
            }
        }
    }

    public byte[] getMessage() {
        return this.data.getMessage().getOctets();
    }

    public CMSSignedData getParsedMessage() {
        return this.doc;
    }
}

