/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.crypto.CryptoException;
import shaded.cfca.sadk.org.bouncycastle.crypto.Signer;
import shaded.cfca.sadk.org.bouncycastle.crypto.agreement.srp.SRP6Client;
import shaded.cfca.sadk.org.bouncycastle.crypto.agreement.srp.SRP6Util;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.AbstractTlsKeyExchange;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.Certificate;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.CertificateRequest;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.DigitallySigned;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.SecurityParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.SignerInputBuffer;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsContext;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsCredentials;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsDSSSigner;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsFatalAlert;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsRSASigner;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsSigner;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsUtils;
import shaded.cfca.sadk.org.bouncycastle.crypto.util.PublicKeyFactory;
import shaded.cfca.sadk.org.bouncycastle.util.BigIntegers;
import shaded.cfca.sadk.org.bouncycastle.util.io.TeeInputStream;

public class TlsSRPKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsSigner tlsSigner;
    protected byte[] identity;
    protected byte[] password;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected byte[] s = null;
    protected BigInteger B = null;
    protected SRP6Client srpClient = new SRP6Client();

    public TlsSRPKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, byte[] identity, byte[] password) {
        super(keyExchange, supportedSignatureAlgorithms);
        switch (keyExchange) {
            case 21: {
                this.tlsSigner = null;
                break;
            }
            case 23: {
                this.tlsSigner = new TlsRSASigner();
                break;
            }
            case 22: {
                this.tlsSigner = new TlsDSSSigner();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.keyExchange = keyExchange;
        this.identity = identity;
        this.password = password;
    }

    public void init(TlsContext context) {
        super.init(context);
        if (this.tlsSigner != null) {
            this.tlsSigner.init(context);
        }
    }

    public void skipServerCredentials() throws IOException {
        if (this.tlsSigner != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.tlsSigner == null) {
            throw new TlsFatalAlert(10);
        }
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        shaded.cfca.sadk.org.bouncycastle.asn1.x509.Certificate x509Cert = serverCertificate.getCertificateAt(0);
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43);
        }
        if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
            throw new TlsFatalAlert(46);
        }
        TlsUtils.validateKeyUsage(x509Cert, 128);
        super.processServerCertificate(serverCertificate);
    }

    public boolean requiresServerKeyExchange() {
        return true;
    }

    public void processServerKeyExchange(InputStream input) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer buf = null;
        InputStream teeIn = input;
        if (this.tlsSigner != null) {
            buf = new SignerInputBuffer();
            teeIn = new TeeInputStream(input, buf);
        }
        byte[] NBytes = TlsUtils.readOpaque16(teeIn);
        byte[] gBytes = TlsUtils.readOpaque16(teeIn);
        byte[] sBytes = TlsUtils.readOpaque8(teeIn);
        byte[] BBytes = TlsUtils.readOpaque16(teeIn);
        if (buf != null) {
            DigitallySigned signed_params = DigitallySigned.parse(this.context, input);
            Signer signer = this.initVerifyer(this.tlsSigner, signed_params.getAlgorithm(), securityParameters);
            buf.updateSigner(signer);
            if (!signer.verifySignature(signed_params.getSignature())) {
                throw new TlsFatalAlert(51);
            }
        }
        BigInteger N = new BigInteger(1, NBytes);
        BigInteger g = new BigInteger(1, gBytes);
        this.s = sBytes;
        try {
            this.B = SRP6Util.validatePublicValue(N, new BigInteger(1, BBytes));
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47);
        }
        this.srpClient.init(N, g, TlsUtils.createHash((short)2), this.context.getSecureRandom());
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream output) throws IOException {
        BigInteger A = this.srpClient.generateClientCredentials(this.s, this.identity, this.password);
        TlsUtils.writeOpaque16(BigIntegers.asUnsignedByteArray(A), output);
    }

    public byte[] generatePremasterSecret() throws IOException {
        try {
            return BigIntegers.asUnsignedByteArray(this.srpClient.calculateSecret(this.B));
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm algorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(algorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

