/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.test;

import shaded.cfca.sadk.org.bouncycastle.crypto.engines.VMPCKSA3Engine;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Hex;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class VMPCKSA3Test
extends SimpleTest {
    private static final byte[] input = new byte[1000000];

    public String getName() {
        return "VMPC-KSA3";
    }

    private void checkByte(byte[] array, int position, byte b) {
        if (array[position] != b) {
            this.fail("Fail on position " + position, new String(Hex.encode(new byte[]{b})), new String(Hex.encode(new byte[]{array[position]})));
        }
    }

    public void performTest() {
        byte[] key = Hex.decode("9661410AB797D8A9EB767C21172DF6C7");
        byte[] iv = Hex.decode("4B5C2F003E67F39557A8D26F3DA2B155");
        KeyParameter kp = new KeyParameter(key);
        ParametersWithIV kpwiv = new ParametersWithIV(kp, iv);
        VMPCKSA3Engine engine = new VMPCKSA3Engine();
        try {
            engine.init(true, kp);
            this.fail("init failed to throw expected exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        engine.init(true, kpwiv);
        this.checkEngine(engine);
        engine.reset();
        byte[] output = this.checkEngine(engine);
        engine.init(false, kpwiv);
        byte[] recovered = new byte[output.length];
        engine.processBytes(output, 0, output.length, recovered, 0);
        if (!Arrays.areEqual(input, recovered)) {
            this.fail("decrypted bytes differ from original bytes");
        }
    }

    private byte[] checkEngine(VMPCKSA3Engine engine) {
        byte[] output = new byte[input.length];
        engine.processBytes(input, 0, output.length, output, 0);
        this.checkByte(output, 0, (byte)-74);
        this.checkByte(output, 1, (byte)-21);
        this.checkByte(output, 2, (byte)-82);
        this.checkByte(output, 3, (byte)-2);
        this.checkByte(output, 252, (byte)72);
        this.checkByte(output, 253, (byte)23);
        this.checkByte(output, 254, (byte)36);
        this.checkByte(output, 255, (byte)115);
        this.checkByte(output, 1020, (byte)29);
        this.checkByte(output, 1021, (byte)-82);
        this.checkByte(output, 1022, (byte)-61);
        this.checkByte(output, 1023, (byte)90);
        this.checkByte(output, 102396, (byte)29);
        this.checkByte(output, 102397, (byte)-89);
        this.checkByte(output, 102398, (byte)-31);
        this.checkByte(output, 102399, (byte)-36);
        return output;
    }

    public static void main(String[] args) {
        VMPCKSA3Test.runTest(new VMPCKSA3Test());
    }
}

