/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.signers;

import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.CryptoException;
import shaded.cfca.sadk.org.bouncycastle.crypto.DataLengthException;
import shaded.cfca.sadk.org.bouncycastle.crypto.Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.Signer;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;

public class GenericSigner
implements Signer {
    private final AsymmetricBlockCipher engine;
    private final Digest digest;
    private boolean forSigning;

    public GenericSigner(AsymmetricBlockCipher engine, Digest digest) {
        this.engine = engine;
        this.digest = digest;
    }

    public void init(boolean forSigning, CipherParameters parameters) {
        this.forSigning = forSigning;
        AsymmetricKeyParameter k = parameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)parameters).getParameters() : (AsymmetricKeyParameter)parameters;
        if (forSigning && !k.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!forSigning && k.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        this.reset();
        this.engine.init(forSigning, parameters);
    }

    public void update(byte input) {
        this.digest.update(input);
    }

    public void update(byte[] input, int inOff, int length) {
        this.digest.update(input, inOff, length);
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (!this.forSigning) {
            throw new IllegalStateException("GenericSigner not initialised for signature generation.");
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        return this.engine.processBlock(hash, 0, hash.length);
    }

    public boolean verifySignature(byte[] signature) {
        if (this.forSigning) {
            throw new IllegalStateException("GenericSigner not initialised for verification");
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] sig = this.engine.processBlock(signature, 0, signature.length);
            return Arrays.constantTimeAreEqual(sig, hash);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void reset() {
        this.digest.reset();
    }
}

