/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.modes.gcm;

import shaded.cfca.sadk.org.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import shaded.cfca.sadk.org.bouncycastle.crypto.modes.gcm.GCMUtil;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;

public class BasicGCMExponentiator
implements GCMExponentiator {
    private int[] x;

    public void init(byte[] x) {
        this.x = GCMUtil.asInts(x);
    }

    public void exponentiateX(long pow, byte[] output) {
        int[] y = GCMUtil.oneAsInts();
        if (pow > 0L) {
            int[] powX = Arrays.clone(this.x);
            do {
                if ((pow & 1L) != 0L) {
                    GCMUtil.multiply(y, powX);
                }
                GCMUtil.multiply(powX, powX);
            } while ((pow >>>= 1) > 0L);
        }
        GCMUtil.asBytes(y, output);
    }
}

