/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.commitments;

import java.security.SecureRandom;
import shaded.cfca.sadk.org.bouncycastle.crypto.Commitment;
import shaded.cfca.sadk.org.bouncycastle.crypto.Committer;
import shaded.cfca.sadk.org.bouncycastle.crypto.DataLengthException;
import shaded.cfca.sadk.org.bouncycastle.crypto.Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.ExtendedDigest;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;

public class GeneralHashCommitter
implements Committer {
    private final Digest digest;
    private final int byteLength;
    private final SecureRandom random;

    public GeneralHashCommitter(ExtendedDigest digest, SecureRandom random) {
        this.digest = digest;
        this.byteLength = digest.getByteLength();
        this.random = random;
    }

    public Commitment commit(byte[] message) {
        if (message.length > this.byteLength / 2) {
            throw new DataLengthException("Message to be committed to too large for digest.");
        }
        byte[] w = new byte[this.byteLength - message.length];
        this.random.nextBytes(w);
        return new Commitment(w, this.calculateCommitment(w, message));
    }

    public boolean isRevealed(Commitment commitment, byte[] message) {
        if (message.length + commitment.getSecret().length != this.byteLength) {
            throw new DataLengthException("Message and witness secret lengths do not match.");
        }
        byte[] calcCommitment = this.calculateCommitment(commitment.getSecret(), message);
        return Arrays.constantTimeAreEqual(commitment.getCommitment(), calcCommitment);
    }

    private byte[] calculateCommitment(byte[] w, byte[] message) {
        byte[] commitment = new byte[this.digest.getDigestSize()];
        this.digest.update(w, 0, w.length);
        this.digest.update(message, 0, message.length);
        this.digest.update((byte)(message.length >>> 8));
        this.digest.update((byte)message.length);
        this.digest.doFinal(commitment, 0);
        return commitment;
    }
}

