/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.agreement.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import junit.framework.TestCase;
import shaded.cfca.sadk.org.bouncycastle.crypto.CryptoException;
import shaded.cfca.sadk.org.bouncycastle.crypto.agreement.jpake.JPAKEPrimeOrderGroup;
import shaded.cfca.sadk.org.bouncycastle.crypto.agreement.jpake.JPAKEPrimeOrderGroups;
import shaded.cfca.sadk.org.bouncycastle.crypto.agreement.jpake.JPAKEUtil;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;

public class JPAKEUtilTest
extends TestCase {
    private static final BigInteger TEN = BigInteger.valueOf(10L);

    public void testValidateGx4() throws CryptoException {
        JPAKEUtil.validateGx4(TEN);
        try {
            JPAKEUtil.validateGx4(BigInteger.ONE);
            JPAKEUtilTest.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public void testValidateGa() throws CryptoException {
        JPAKEUtil.validateGa(TEN);
        try {
            JPAKEUtil.validateGa(BigInteger.ONE);
            JPAKEUtilTest.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public void testValidateParticipantIdsDiffer() throws CryptoException {
        JPAKEUtil.validateParticipantIdsDiffer("a", "b");
        JPAKEUtil.validateParticipantIdsDiffer("a", "A");
        try {
            JPAKEUtil.validateParticipantIdsDiffer("a", "a");
            JPAKEUtilTest.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public void testValidateParticipantIdsEqual() throws CryptoException {
        JPAKEUtil.validateParticipantIdsEqual("a", "a");
        try {
            JPAKEUtil.validateParticipantIdsEqual("a", "b");
            JPAKEUtilTest.fail();
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public void testValidateMacTag() throws CryptoException {
        JPAKEPrimeOrderGroup pg1 = JPAKEPrimeOrderGroups.SUN_JCE_1024;
        SecureRandom random = new SecureRandom();
        SHA256Digest digest = new SHA256Digest();
        BigInteger x1 = JPAKEUtil.generateX1(pg1.getQ(), random);
        BigInteger x2 = JPAKEUtil.generateX2(pg1.getQ(), random);
        BigInteger x3 = JPAKEUtil.generateX1(pg1.getQ(), random);
        BigInteger x4 = JPAKEUtil.generateX2(pg1.getQ(), random);
        BigInteger gx1 = JPAKEUtil.calculateGx(pg1.getP(), pg1.getG(), x1);
        BigInteger gx2 = JPAKEUtil.calculateGx(pg1.getP(), pg1.getG(), x2);
        BigInteger gx3 = JPAKEUtil.calculateGx(pg1.getP(), pg1.getG(), x3);
        BigInteger gx4 = JPAKEUtil.calculateGx(pg1.getP(), pg1.getG(), x4);
        BigInteger gB = JPAKEUtil.calculateGA(pg1.getP(), gx3, gx1, gx2);
        BigInteger s = JPAKEUtil.calculateS("password".toCharArray());
        BigInteger xs = JPAKEUtil.calculateX2s(pg1.getQ(), x4, s);
        BigInteger B = JPAKEUtil.calculateA(pg1.getP(), pg1.getQ(), gB, xs);
        BigInteger keyingMaterial = JPAKEUtil.calculateKeyingMaterial(pg1.getP(), pg1.getQ(), gx4, x2, s, B);
        BigInteger macTag = JPAKEUtil.calculateMacTag("participantId", "partnerParticipantId", gx1, gx2, gx3, gx4, keyingMaterial, digest);
        JPAKEUtil.validateMacTag("partnerParticipantId", "participantId", gx3, gx4, gx1, gx2, keyingMaterial, digest, macTag);
        try {
            JPAKEUtil.validateMacTag("participantId", "partnerParticipantId", gx1, gx2, gx3, gx4, keyingMaterial, digest, macTag);
            JPAKEUtilTest.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        try {
            JPAKEUtil.validateMacTag("participantId", "partnerParticipantId", gx3, gx4, gx1, gx2, keyingMaterial, digest, macTag);
            JPAKEUtilTest.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
    }

    public void testValidateNotNull() {
        JPAKEUtil.validateNotNull("a", "description");
        try {
            JPAKEUtil.validateNotNull(null, "description");
            JPAKEUtilTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testValidateZeroKnowledgeProof() throws CryptoException {
        JPAKEPrimeOrderGroup pg1 = JPAKEPrimeOrderGroups.SUN_JCE_1024;
        SecureRandom random = new SecureRandom();
        SHA256Digest digest1 = new SHA256Digest();
        BigInteger x1 = JPAKEUtil.generateX1(pg1.getQ(), random);
        BigInteger gx1 = JPAKEUtil.calculateGx(pg1.getP(), pg1.getG(), x1);
        String participantId1 = "participant1";
        BigInteger[] zkp1 = JPAKEUtil.calculateZeroKnowledgeProof(pg1.getP(), pg1.getQ(), pg1.getG(), gx1, x1, participantId1, digest1, random);
        JPAKEUtil.validateZeroKnowledgeProof(pg1.getP(), pg1.getQ(), pg1.getG(), gx1, zkp1, participantId1, digest1);
        JPAKEPrimeOrderGroup pg2 = JPAKEPrimeOrderGroups.NIST_3072;
        try {
            JPAKEUtil.validateZeroKnowledgeProof(pg2.getP(), pg2.getQ(), pg2.getG(), gx1, zkp1, participantId1, digest1);
            JPAKEUtilTest.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        SHA1Digest digest2 = new SHA1Digest();
        try {
            JPAKEUtil.validateZeroKnowledgeProof(pg1.getP(), pg1.getQ(), pg1.getG(), gx1, zkp1, participantId1, digest2);
            JPAKEUtilTest.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        String participantId2 = "participant2";
        try {
            JPAKEUtil.validateZeroKnowledgeProof(pg1.getP(), pg1.getQ(), pg1.getG(), gx1, zkp1, participantId2, digest1);
            JPAKEUtilTest.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        BigInteger x2 = JPAKEUtil.generateX1(pg1.getQ(), random);
        BigInteger gx2 = JPAKEUtil.calculateGx(pg1.getP(), pg1.getG(), x2);
        try {
            JPAKEUtil.validateZeroKnowledgeProof(pg1.getP(), pg1.getQ(), pg1.getG(), gx2, zkp1, participantId1, digest1);
            JPAKEUtilTest.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        BigInteger[] zkp2 = JPAKEUtil.calculateZeroKnowledgeProof(pg1.getP(), pg1.getQ(), pg1.getG(), gx2, x2, participantId1, digest1, random);
        try {
            JPAKEUtil.validateZeroKnowledgeProof(pg1.getP(), pg1.getQ(), pg1.getG(), gx1, zkp2, participantId1, digest1);
            JPAKEUtilTest.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        try {
            JPAKEUtil.validateZeroKnowledgeProof(pg1.getP(), pg1.getQ(), pg1.getG(), BigInteger.ZERO, zkp1, participantId1, digest1);
            JPAKEUtilTest.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        try {
            JPAKEUtil.validateZeroKnowledgeProof(pg1.getP(), pg1.getQ(), pg1.getG(), pg1.getP(), zkp1, participantId1, digest1);
            JPAKEUtilTest.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
        try {
            JPAKEUtil.validateZeroKnowledgeProof(pg1.getP(), pg1.getQ(), pg1.getG(), pg1.getQ().add(BigInteger.ONE), zkp1, participantId1, digest1);
            JPAKEUtilTest.fail();
        }
        catch (CryptoException e) {
            // empty catch block
        }
    }
}

