/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cms.jcajce;

import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Mac;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSException;
import shaded.cfca.sadk.org.bouncycastle.cms.RecipientOperator;
import shaded.cfca.sadk.org.bouncycastle.cms.jcajce.JceKeyTransRecipient;
import shaded.cfca.sadk.org.bouncycastle.jcajce.io.MacOutputStream;
import shaded.cfca.sadk.org.bouncycastle.operator.GenericKey;
import shaded.cfca.sadk.org.bouncycastle.operator.MacCalculator;

public class JceKeyTransAuthenticatedRecipient
extends JceKeyTransRecipient {
    public JceKeyTransAuthenticatedRecipient(PrivateKey recipientKey) {
        super(recipientKey);
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentMacAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        final Key secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentMacAlgorithm, encryptedContentEncryptionKey);
        final Mac dataMac = this.contentHelper.createContentMac(secretKey, contentMacAlgorithm);
        return new RecipientOperator(new MacCalculator(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentMacAlgorithm;
            }

            public GenericKey getKey() {
                return new GenericKey(secretKey);
            }

            public OutputStream getOutputStream() {
                return new MacOutputStream(dataMac);
            }

            public byte[] getMac() {
                return dataMac.doFinal();
            }
        });
    }
}

