/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cms;

import java.io.IOException;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.KEKIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.cms.AuthAttributesProvider;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSException;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSSecureReadable;
import shaded.cfca.sadk.org.bouncycastle.cms.KEKRecipient;
import shaded.cfca.sadk.org.bouncycastle.cms.KEKRecipientId;
import shaded.cfca.sadk.org.bouncycastle.cms.Recipient;
import shaded.cfca.sadk.org.bouncycastle.cms.RecipientInformation;
import shaded.cfca.sadk.org.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

