/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cert.test;

import java.io.IOException;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.cert.X509ExtensionUtils;
import shaded.cfca.sadk.org.bouncycastle.cert.test.SHA1DigestCalculator;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Base64;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Hex;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class X509ExtensionUtilsTest
extends SimpleTest {
    private static byte[] pubKeyInfo = Base64.decode("MFgwCwYJKoZIhvcNAQEBA0kAMEYCQQC6wMMmHYMZszT/7bNFMn+gaZoiWJLVP8ODRuu1C2jeAeQpxM+5Oe7PaN2GNy3nBE4EOYkB5pMJWA0y9n04FX8NAgED");
    private static byte[] shaID = Hex.decode("d8128a06d6c2feb0865994a2936e7b75b836a021");
    private static byte[] shaTruncID = Hex.decode("436e7b75b836a021");
    private X509ExtensionUtils x509ExtensionUtils = new X509ExtensionUtils(new SHA1DigestCalculator());

    public String getName() {
        return "X509ExtensionUtilsTest";
    }

    public void performTest() throws IOException {
        SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(pubKeyInfo));
        SubjectKeyIdentifier ski = this.x509ExtensionUtils.createSubjectKeyIdentifier(pubInfo);
        if (!Arrays.areEqual(shaID, ski.getKeyIdentifier())) {
            this.fail("SHA-1 ID does not match");
        }
        if (!Arrays.areEqual(shaTruncID, (ski = this.x509ExtensionUtils.createTruncatedSubjectKeyIdentifier(pubInfo)).getKeyIdentifier())) {
            this.fail("truncated SHA-1 ID does not match");
        }
    }

    public static void main(String[] args) {
        X509ExtensionUtilsTest.runTest(new X509ExtensionUtilsTest());
    }
}

