/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.asn1.test;

import java.io.IOException;
import junit.framework.TestCase;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Boolean;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Enumerated;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Hex;

public class EnumeratedTest
extends TestCase {
    private static final byte[] MultipleSingleByteItems = Hex.decode("30060a01010101ff");
    private static final byte[] MultipleDoubleByteItems = Hex.decode("30080a0201010a020202");
    private static final byte[] MultipleTripleByteItems = Hex.decode("300a0a0301010106032b0601");

    public void testReadingMultipleSingleByteItems() throws IOException {
        ASN1Primitive obj = ASN1Primitive.fromByteArray(MultipleSingleByteItems);
        EnumeratedTest.assertTrue((String)"Null ASN.1 SEQUENCE", (boolean)(obj instanceof ASN1Sequence));
        ASN1Sequence sequence = (ASN1Sequence)obj;
        EnumeratedTest.assertEquals((String)"2 items expected", (int)2, (int)sequence.size());
        ASN1Enumerated enumerated = ASN1Enumerated.getInstance(sequence.getObjectAt(0));
        EnumeratedTest.assertNotNull((String)"ENUMERATED expected", (Object)enumerated);
        EnumeratedTest.assertEquals((String)"Unexpected ENUMERATED value", (int)1, (int)enumerated.getValue().intValue());
        ASN1Boolean b = ASN1Boolean.getInstance(sequence.getObjectAt(1));
        EnumeratedTest.assertNotNull((String)"BOOLEAN expected", (Object)b);
        EnumeratedTest.assertTrue((String)"Unexpected BOOLEAN value", (boolean)b.isTrue());
    }

    public void testReadingMultipleDoubleByteItems() throws IOException {
        ASN1Primitive obj = ASN1Primitive.fromByteArray(MultipleDoubleByteItems);
        EnumeratedTest.assertTrue((String)"Null ASN.1 SEQUENCE", (boolean)(obj instanceof ASN1Sequence));
        ASN1Sequence sequence = (ASN1Sequence)obj;
        EnumeratedTest.assertEquals((String)"2 items expected", (int)2, (int)sequence.size());
        ASN1Enumerated enumerated1 = ASN1Enumerated.getInstance(sequence.getObjectAt(0));
        EnumeratedTest.assertNotNull((String)"ENUMERATED expected", (Object)enumerated1);
        EnumeratedTest.assertEquals((String)"Unexpected ENUMERATED value", (int)257, (int)enumerated1.getValue().intValue());
        ASN1Enumerated enumerated2 = ASN1Enumerated.getInstance(sequence.getObjectAt(1));
        EnumeratedTest.assertNotNull((String)"ENUMERATED expected", (Object)enumerated2);
        EnumeratedTest.assertEquals((String)"Unexpected ENUMERATED value", (int)514, (int)enumerated2.getValue().intValue());
    }

    public void testReadingMultipleTripleByteItems() throws IOException {
        ASN1Primitive obj = ASN1Primitive.fromByteArray(MultipleTripleByteItems);
        EnumeratedTest.assertTrue((String)"Null ASN.1 SEQUENCE", (boolean)(obj instanceof ASN1Sequence));
        ASN1Sequence sequence = (ASN1Sequence)obj;
        EnumeratedTest.assertEquals((String)"2 items expected", (int)2, (int)sequence.size());
        ASN1Enumerated enumerated = ASN1Enumerated.getInstance(sequence.getObjectAt(0));
        EnumeratedTest.assertNotNull((String)"ENUMERATED expected", (Object)enumerated);
        EnumeratedTest.assertEquals((String)"Unexpected ENUMERATED value", (int)65793, (int)enumerated.getValue().intValue());
        ASN1ObjectIdentifier objectId = ASN1ObjectIdentifier.getInstance(sequence.getObjectAt(1));
        EnumeratedTest.assertNotNull((String)"OBJECT IDENTIFIER expected", (Object)objectId);
        EnumeratedTest.assertEquals((String)"Unexpected OBJECT IDENTIFIER value", (String)"1.3.6.1", (String)objectId.getId());
    }
}

