/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.lib.crypto.bcsoft;

import java.math.BigInteger;
import shaded.cfca.sadk.algorithm.sm2.SM2Param;
import shaded.cfca.sadk.algorithm.sm2.SM2Result;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECPoint;

public class BCSoftSM2 {
    SM2Param sm2Param = new SM2Param();

    public void sign(byte[] md, BigInteger userD, SM2Result sm2Ret) {
        BigInteger e = new BigInteger(1, md);
        BigInteger k = null;
        ECPoint kp = null;
        BigInteger r = null;
        BigInteger s = null;
        while (true) {
            AsymmetricCipherKeyPair keypair = this.sm2Param.ecc_key_pair_generator.generateKeyPair();
            ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keypair.getPrivate();
            ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keypair.getPublic();
            k = ecpriv.getD();
            kp = ecpub.getQ();
            r = e.add(kp.getX().toBigInteger());
            if ((r = r.mod(SM2Param.ecc_n)).equals(BigInteger.ZERO)) continue;
            if (r.add(k).equals(SM2Param.ecc_n)) continue;
            BigInteger da_1 = userD.add(BigInteger.ONE);
            da_1 = da_1.modInverse(SM2Param.ecc_n);
            s = r.multiply(userD);
            s = k.subtract(s).mod(SM2Param.ecc_n);
            if (!(s = da_1.multiply(s).mod(SM2Param.ecc_n)).equals(BigInteger.ZERO)) break;
        }
        sm2Ret.r = r;
        sm2Ret.s = s;
    }

    public boolean verify(byte[] md, ECPoint userKey, SM2Result sm2Ret) {
        sm2Ret.R = null;
        BigInteger e = new BigInteger(1, md);
        BigInteger t = sm2Ret.r.add(sm2Ret.s).mod(SM2Param.ecc_n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint x1y1 = SM2Param.ecc_point_g.multiply(sm2Ret.s);
        x1y1 = x1y1.add(userKey.multiply(t));
        sm2Ret.R = e.add(x1y1.getX().toBigInteger()).mod(SM2Param.ecc_n);
        return sm2Ret.r.equals(sm2Ret.R);
    }
}

