/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.algorithm.sm2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import shaded.cfca.sadk.algorithm.sm2.SM2Param;
import shaded.cfca.sadk.algorithm.sm2.SM3Digest;
import shaded.cfca.sadk.algorithm.util.BigIntegerUtil;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERSequence;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECFieldElement;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECPoint;

public class SM2Crypto {
    private int ct = 1;
    private ECPoint p2;
    private ECPoint C1 = null;
    private SM3Digest sm3KeyBase;
    private SM3Digest sm3Digest;
    private byte[] key = new byte[32];
    private byte keyOff = 0;
    private BigInteger userD;

    private void reSet() {
        this.sm3KeyBase = new SM3Digest();
        this.sm3Digest = new SM3Digest();
        byte[] p = BigIntegerUtil.asUnsigned32ByteArray(this.p2.getX().toBigInteger());
        this.sm3KeyBase.update(p, 0, p.length);
        this.sm3Digest.update(p, 0, p.length);
        p = BigIntegerUtil.asUnsigned32ByteArray(this.p2.getY().toBigInteger());
        this.sm3KeyBase.update(p, 0, p.length);
        this.ct = 1;
        this.nextKey();
    }

    private void nextKey() {
        SM3Digest sm3keycur = new SM3Digest(this.sm3KeyBase);
        sm3keycur.update((byte)(this.ct >> 24 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 16 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 8 & 0xFF));
        sm3keycur.update((byte)(this.ct & 0xFF));
        sm3keycur.doFinal(this.key, 0);
        this.keyOff = 0;
        ++this.ct;
    }

    public void initEncrypt(ECPoint userKey) {
        BigInteger k = null;
        AsymmetricCipherKeyPair key = new SM2Param().ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        k = ecpriv.getD();
        this.C1 = ecpub.getQ();
        this.p2 = userKey.multiply(k);
        this.reSet();
    }

    public void initDecrypt(BigInteger userD) {
        this.userD = userD;
    }

    public byte[] encrypt(byte[] sourceData) {
        ASN1EncodableVector sm2Vec = new ASN1EncodableVector();
        byte[] data = (byte[])sourceData.clone();
        this.sm3Digest.update(data, 0, data.length);
        int i = 0;
        while (i < data.length) {
            if (this.keyOff == this.key.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            data[n] = (byte)(data[n] ^ this.key[by]);
        }
        DEROctetString C2 = new DEROctetString(data);
        ASN1Integer C1CoordX = new ASN1Integer(this.C1.getX().toBigInteger());
        ASN1Integer C1CoordY = new ASN1Integer(this.C1.getY().toBigInteger());
        byte[] C3Data = new byte[32];
        this.dofinal(C3Data);
        DEROctetString C3 = new DEROctetString(C3Data);
        sm2Vec.add(C1CoordX);
        sm2Vec.add(C1CoordY);
        sm2Vec.add(C3);
        sm2Vec.add(C2);
        DERSequence sm2Seq = new DERSequence(sm2Vec);
        try {
            return sm2Seq.getEncoded();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public byte[] decrypt(byte[] encryptData) throws Exception {
        ASN1InputStream asn1Is = new ASN1InputStream(encryptData);
        ASN1Sequence sm2Seq = null;
        try {
            sm2Seq = (ASN1Sequence)asn1Is.readObject();
        }
        catch (IOException e) {
            byte[] data = (byte[])encryptData.clone();
            byte[] c1X_byte = new byte[32];
            byte[] c1Y_byte = new byte[32];
            System.arraycopy(data, 0, c1X_byte, 0, 32);
            System.arraycopy(data, 32, c1Y_byte, 0, 32);
            BigInteger ecc_c1X = new BigInteger(1, c1X_byte);
            BigInteger ecc_c1Y = new BigInteger(1, c1Y_byte);
            ECPoint c1 = this.getECPoint(ecc_c1X, ecc_c1Y);
            this.p2 = c1.multiply(this.userD);
            this.reSet();
            int encryptedLen = data.length - 64 - 32;
            byte[] encrypted = new byte[encryptedLen];
            System.arraycopy(data, 64, encrypted, 0, encryptedLen);
            int i = 0;
            while (i < encryptedLen) {
                if (this.keyOff == this.key.length) {
                    this.nextKey();
                }
                int n = i++;
                byte by = this.keyOff;
                this.keyOff = (byte)(by + 1);
                encrypted[n] = (byte)(encrypted[n] ^ this.key[by]);
            }
            this.sm3Digest.update(encrypted, 0, encryptedLen);
            byte[] c3 = new byte[32];
            this.dofinal(c3);
            byte[] old_c3 = new byte[32];
            System.arraycopy(data, 64 + encryptedLen, old_c3, 0, 32);
            if (Arrays.equals(c3, old_c3)) {
                return encrypted;
            }
            throw new Exception("can not decrypt, Check if the encryption block is right");
        }
        ASN1Integer C1coordX = (ASN1Integer)sm2Seq.getObjectAt(0);
        ASN1Integer C1coordY = (ASN1Integer)sm2Seq.getObjectAt(1);
        ECPoint c1 = this.getECPoint(C1coordX.getValue(), C1coordY.getValue());
        this.p2 = c1.multiply(this.userD);
        this.reSet();
        DEROctetString C2 = (DEROctetString)sm2Seq.getObjectAt(3);
        byte[] encrypted = C2.getOctets();
        int encryptedLen = encrypted.length;
        int i = 0;
        while (i < encryptedLen) {
            if (this.keyOff == this.key.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            encrypted[n] = (byte)(encrypted[n] ^ this.key[by]);
        }
        DEROctetString old_C3 = (DEROctetString)sm2Seq.getObjectAt(2);
        byte[] old_C3b = old_C3.getOctets();
        byte[] C3b = new byte[32];
        this.sm3Digest.update(encrypted, 0, encryptedLen);
        this.dofinal(C3b);
        if (Arrays.equals(C3b, old_C3b)) {
            return encrypted;
        }
        throw new Exception("can not decrypt, Check if the encrypt block is right");
    }

    private ECPoint getECPoint(BigInteger X, BigInteger Y) {
        BigInteger ecc_p = new BigInteger(1, SM2Param.getP());
        ECFieldElement.Fp ecc_X_fieldelement = new ECFieldElement.Fp(ecc_p, X);
        ECFieldElement.Fp ecc_Y_fieldelement = new ECFieldElement.Fp(ecc_p, Y);
        BigInteger ecc_a = new BigInteger(1, SM2Param.getA());
        BigInteger ecc_b = new BigInteger(1, SM2Param.getB());
        ECCurve.Fp ecc_curve = new ECCurve.Fp(ecc_p, ecc_a, ecc_b);
        return new ECPoint.Fp(ecc_curve, ecc_X_fieldelement, ecc_Y_fieldelement);
    }

    private void dofinal(byte[] c3) {
        byte[] p = BigIntegerUtil.asUnsigned32ByteArray(this.p2.getY().toBigInteger());
        this.sm3Digest.update(p, 0, p.length);
        this.sm3Digest.doFinal(c3, 0);
        this.reSet();
    }
}

