/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.util;

import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import netbank.firm.base.SystemProperty;
import netbank.firm.config.CibProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.org.apache.commons.lang.StringUtils;
import shade.org.apache.http.Consts;
import shade.org.apache.http.HttpEntity;
import shade.org.apache.http.StatusLine;
import shade.org.apache.http.client.HttpResponseException;
import shade.org.apache.http.client.config.RequestConfig;
import shade.org.apache.http.client.methods.CloseableHttpResponse;
import shade.org.apache.http.client.methods.HttpPost;
import shade.org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import shade.org.apache.http.entity.StringEntity;
import shade.org.apache.http.impl.client.CloseableHttpClient;
import shade.org.apache.http.impl.client.HttpClients;
import shade.org.apache.http.util.EntityUtils;

public class HealthCheckUtil {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckUtil.class);
    private static final String HEALTHY_CHECK_PATH = "hb.html";
    private static final String HEALTHY_CONNECT_PATH = "online/PFCFoxSecurities";
    private static final String HEALTH_MESSAGE = "hbok!";
    private static final String UNHEALTH_MESSAGE = "nohbok!";
    private static final String HEALTHY_CHECK_FLAG = "Health-Check-For";
    private static final int CONNECT_TIMEOUT = 2000;
    private static final int READ_TIMEOUT = 3000;
    private static final int CONNECT_TIMEOUT_NOSSL = 10000;
    private static final int READ_TIMEOUT_NOSSL = 15000;

    public static boolean check_noMBFE(CibProfile param) {
        String serverUrl = param.getServiceUrl().replace(HEALTHY_CONNECT_PATH, HEALTHY_CHECK_PATH);
        boolean isHealthFlag = HealthCheckUtil.check(serverUrl, null, 0);
        return isHealthFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean check(CibProfile param) throws Exception {
        if (HealthCheckUtil.checkNoSsl(param)) {
            String content = "Health-Check-For-" + SystemProperty.getInstance().getProperty("ncid", true);
            String responseBody = "";
            boolean isHealthFlag = true;
            try (CloseableHttpClient httpclient = HttpClients.custom().setMaxConnTotal(10).build();){
                RequestConfig ex = RequestConfig.custom().setSocketTimeout(param.getTimeOut() * 1000).setConnectTimeout(param.getTimeOut() * 1000).build();
                HttpPost httpPost = new HttpPost(param.getServiceUrl());
                httpPost.setConfig(ex);
                StringEntity stringEntity = new StringEntity(content, Consts.UTF_8);
                stringEntity.setContentType("application/x-www-form-urlencoded");
                httpPost.setEntity(stringEntity);
                CloseableHttpResponse response = httpclient.execute(httpPost);
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() >= 300) {
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                }
                HttpEntity entity = response.getEntity();
                responseBody = EntityUtils.toString(entity);
                log.info("\u5ba2\u6237\u7aef\u8bf7\u6c42\u62a5\u6587[\r\n" + content + "\r\n], \u94f6\u884c\u7aef\u54cd\u5e94\u62a5\u6587[\r\n" + responseBody + "\r\n]");
                if (HEALTH_MESSAGE.equals(responseBody)) {
                    log.info("\u4ee3\u7406\u8f6f\u4ef6\u4e0e\u94f6\u884c\u670d\u52a1\u7aef\u5efa\u7acb\u8fde\u63a5\u6210\u529f\uff01");
                    EntityUtils.consume(entity);
                } else if (UNHEALTH_MESSAGE.equals(responseBody)) {
                    log.error("\u4ee3\u7406\u8f6f\u4ef6\u4e0e\u94f6\u884c\u670d\u52a1\u7aef\u5efa\u7acb\u8fde\u63a5\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\uff01");
                    EntityUtils.consume(entity);
                    isHealthFlag = false;
                } else {
                    log.error("\u6d4b\u8bd5\u8fde\u63a5\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...");
                    EntityUtils.consume(entity);
                    isHealthFlag = false;
                }
            }
            return isHealthFlag;
        }
        log.error("ERP\u4e0e\u4ee3\u7406\u8f6f\u4ef6\u5efa\u7acb\u8fde\u63a5\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\uff01");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkNoSsl(CibProfile param) {
        HttpURLConnection conn = null;
        try {
            URL ex = new URL(param.getServiceUrl());
            conn = (HttpURLConnection)ex.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(15000);
            conn.connect();
            log.info("ERP\u4e0e\u4ee3\u7406\u8f6f\u4ef6\u5efa\u7acb\u8fde\u63a5\u6210\u529f\uff01");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("ERP\u4e0e\u4ee3\u7406\u8f6f\u4ef6\u5efa\u7acb\u8fde\u63a5\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\uff01", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static boolean check(String serverUrl, String proxyHost, int proxyPort) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL url = new URL(serverUrl);
            if (StringUtils.isEmpty(proxyHost) || proxyPort == 0) {
                httpURLConnection = (HttpURLConnection)url.openConnection();
            } else {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                httpURLConnection = (HttpURLConnection)url.openConnection(proxy);
            }
            httpURLConnection.setConnectTimeout(2000);
            httpURLConnection.setReadTimeout(3000);
            if (httpURLConnection instanceof HttpsURLConnection) {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, new TrustManager[]{new EasyTrustManager()}, null);
                HttpsURLConnection httpsConnection = (HttpsURLConnection)httpURLConnection;
                httpsConnection.setSSLSocketFactory(context.getSocketFactory());
                httpsConnection.setHostnameVerifier(new AllowAllHostnameVerifier());
            }
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoOutput(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.connect();
            int code = httpURLConnection.getResponseCode();
            log.info("Start Heathy Checker, Server Path: [{}], Response Code:[{}]", (Object)serverUrl, (Object)code);
            if (code >= 200 && code < 400) {
                return true;
            }
        }
        catch (Exception exp) {
            log.error("Heathy Cheack failed. Server Path: [{}]", (Object)serverUrl, (Object)exp);
        }
        return false;
    }

    private static class EasyTrustManager
    implements X509TrustManager {
        private EasyTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

