/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetAddress;
import java.net.URI;
import java.util.concurrent.locks.ReentrantLock;
import netbank.firm.base.CFCASignature;
import netbank.firm.base.GMUtils;
import netbank.firm.config.CibProfile;
import netbank.firm.config.Config;
import netbank.firm.config.SystemTypeEnum;
import netbank.firm.server.dto.QueryDcConfigResponseBean;
import netbank.firm.server.service.ConfigService;
import netbank.firm.util.CpuUtil;
import netbank.firm.util.FOXDesUtil;
import netbank.firm.util.MacUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.org.apache.commons.lang.StringUtils;

public class ContentUtil {
    private static final Logger log = LoggerFactory.getLogger(ContentUtil.class);
    private static final ReentrantLock LOCK = new ReentrantLock();

    public static String encryptPassword(String content, CibProfile profile) throws Exception {
        int endIndex;
        if (StringUtils.isEmpty(content)) {
            return content;
        }
        if (!content.contains("<USERPASS>") || !content.contains("</USERPASS>")) {
            return content;
        }
        int startIndex = content.indexOf("<USERPASS>") + 10;
        String pwd = content.substring(startIndex, endIndex = content.indexOf("</USERPASS>"));
        if (StringUtils.isNotBlank(pwd)) {
            if (pwd.startsWith("{DES}")) {
                FOXDesUtil desUtil = new FOXDesUtil();
                pwd = desUtil.doDecrypt(pwd);
                pwd = ContentUtil.sm2Encrypt(pwd, profile);
            } else if (!pwd.startsWith("{SM2}")) {
                pwd = ContentUtil.sm2Encrypt(pwd, profile);
            } else {
                log.debug("\u5bc6\u7801\u52a0\u5bc6\u65b9\u5f0f\u5df2\u7ecf\u662fSM2");
            }
        }
        String cipherText = "<USERPASS>" + pwd + "</USERPASS>";
        return content.replaceAll("<USERPASS>\\S*</USERPASS>", cipherText);
    }

    private static String sm2Encrypt(String pwd, CibProfile profile) throws Exception {
        if (!StringUtils.isEmpty(Config.getInstance().getSm2PublicKeyX()) && !StringUtils.isEmpty(Config.getInstance().getSm2PublicKeyY())) {
            return GMUtils.sm2Encrypt(pwd, Config.getInstance().getSm2PublicKeyX() + Config.getInstance().getSm2PublicKeyY());
        }
        LOCK.lock();
        try {
            QueryDcConfigResponseBean.ResponseBody responseBody = ConfigService.queryConfig(profile);
            if (StringUtils.isEmpty(responseBody.getSm2PublicKeyX()) || StringUtils.isEmpty(responseBody.getSm2PublicKeyY())) {
                throw new Exception("\u67e5\u8be2\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            Config.getInstance().setSm2PublicKeyX(responseBody.getSm2PublicKeyX());
            Config.getInstance().setSm2PublicKeyY(responseBody.getSm2PublicKeyY());
            Config.startTask(profile);
        }
        finally {
            LOCK.unlock();
        }
        return GMUtils.sm2Encrypt(pwd, Config.getInstance().getSm2PublicKeyX() + Config.getInstance().getSm2PublicKeyY());
    }

    public static DefaultFullHttpRequest buildRequestBean(String content, URI uri, CibProfile profile) throws Exception {
        CFCASignature signature = new CFCASignature();
        signature.setProfile(profile);
        String signedData = signature.signature(content);
        if (log.isDebugEnabled()) {
            log.debug("\u7b7e\u540d\u6570\u636e[" + signedData + "]");
        }
        ByteBuf byteBuf = Unpooled.copiedBuffer(signedData.getBytes());
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uri.toASCIIString(), byteBuf);
        String macAddress = MacUtil.getLocalMac();
        String cpuId = CpuUtil.getCupId();
        String ipAddr = InetAddress.getLocalHost().getHostAddress();
        String pattern = "\\r\\n|\\r|\\n|\\t";
        String javaVmInfo = System.getProperty("java.vm.info").replaceAll(pattern, " ");
        String javaVersion = System.getProperty("java.version").replaceAll(pattern, " ");
        String osName = System.getProperty("os.name").replaceAll(pattern, " ");
        String osVersion = System.getProperty("os.version").replaceAll(pattern, " ");
        String osArch = System.getProperty("os.arch").replaceAll(pattern, " ");
        String userCountry = System.getProperty("user.country").replaceAll(pattern, " ");
        String userLanguage = System.getProperty("user.language").replaceAll(pattern, " ");
        request.headers().set("Request_Tag", (Object)ContentUtil.getRequestTag(content));
        request.headers().set("Mac_Addr", (Object)macAddress);
        request.headers().set("CPU_Info", (Object)cpuId);
        request.headers().set("Ip_Addr", (Object)ipAddr);
        request.headers().set("DClient-Version", (Object)"CFCA-V3");
        request.headers().set("Soft-Version", (Object)"ClientLess_v2.1.1");
        request.headers().set("Content-Type", (Object)"text/xml; charset=GB18030");
        request.headers().set("Connection", (Object)"Close");
        request.headers().set("Intensoft-Sign", (Object)"PKCS12");
        request.headers().set("ONE_STEP", (Object)"YES");
        request.headers().set("Entrust-Client", (Object)"SOFT_CERT");
        request.headers().set("User_Agent", (Object)(javaVmInfo + "; " + javaVersion + "; " + osName + "; " + osVersion + "; " + osArch + "; " + userCountry + "; " + userLanguage));
        request.headers().set("Content-Length", (Object)request.content().readableBytes());
        request.headers().set("Host", (Object)uri.getHost());
        byteBuf.retain();
        return request;
    }

    private static String getRequestTag(String content) {
        try {
            int requestWrapperTagIndex = content.indexOf("<SECURITIES_MSGSRQV1>");
            if (requestWrapperTagIndex != -1) {
                String substring = content.substring(requestWrapperTagIndex + 21);
                return substring.substring(substring.indexOf("<") + 1, substring.indexOf(">"));
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8bf7\u6c42\u6807\u7b7e\u5f02\u5e38:", e);
        }
        return "";
    }

    public static SystemTypeEnum getSystemType() {
        return SystemTypeEnum.getEnumByBitName(System.getProperty("sun.arch.data.model"));
    }

    public static Integer getSystemTypeCode() {
        return SystemTypeEnum.getEnumByBitName(System.getProperty("sun.arch.data.model")).getCode();
    }
}

