/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.handler;

import netbank.firm.config.CibProfile;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.service.HealthCheckService;
import netbank.firm.util.HealthCheckUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckServiceHandler
implements HealthCheckService {
    private static Logger log = LoggerFactory.getLogger(HealthCheckServiceHandler.class);
    private CibProfile profile;

    public HealthCheckServiceHandler() {
    }

    public HealthCheckServiceHandler(CibProfile profile) {
        this.profile = profile;
    }

    @Override
    public boolean putCheckMessage_noMBFE() {
        return HealthCheckUtil.check_noMBFE(this.profile);
    }

    @Override
    public boolean putCheckMessage() throws DcfirmException {
        boolean isHealthFlag = true;
        try {
            isHealthFlag = HealthCheckUtil.check(this.profile);
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.C004.getCode(), e.getMessage());
        }
        return isHealthFlag;
    }
}

