/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import netbank.firm.base.SystemProperty;
import netbank.firm.config.CibProfile;
import netbank.firm.decoder.MessageDecoder;
import netbank.firm.dispatch.SslTypeEnum;
import netbank.firm.dispatcher.DecoderDispatcher;
import netbank.firm.encoder.MessageDigestEncoder;
import netbank.firm.encoder.MessageEncoder;
import netbank.firm.encoder.Object2Message;
import netbank.firm.handler.TimeoutHandler;
import netbank.firm.util.ChannelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDownFileChannelInitializer_noMBFE
extends ChannelInitializer<SocketChannel> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDownFileChannelInitializer_noMBFE.class);
    private CibProfile cibProfile;
    private SslTypeEnum sslTypeEnum;

    public DefaultDownFileChannelInitializer_noMBFE(CibProfile cibProfile, SslTypeEnum sslTypeEnum) {
        this.cibProfile = cibProfile;
        this.sslTypeEnum = sslTypeEnum;
    }

    @Override
    protected void initChannel(SocketChannel socketChannel) throws Exception {
        int readerIdleTimeSeconds = Integer.parseInt(SystemProperty.getInstance().getProperty("netty.reader.idletime.seconds", "60"));
        int writerIdleTimeSeconds = Integer.parseInt(SystemProperty.getInstance().getProperty("netty.writer.idletime.seconds", "60"));
        int allIdleTimeSeconds = Integer.parseInt(SystemProperty.getInstance().getProperty("netty.all.idletime.seconds", "60"));
        ChannelPipeline p = socketChannel.pipeline();
        p.addLast("ssl", (ChannelHandler)ChannelUtil.getSslHandler(socketChannel, this.sslTypeEnum, this.cibProfile));
        p.addLast("decoders", (ChannelHandler)new DecoderDispatcher());
        p.addLast("messDecoder", (ChannelHandler)new MessageDecoder());
        p.addLast("messEncoder", (ChannelHandler)new MessageEncoder());
        p.addLast("digest", (ChannelHandler)new MessageDigestEncoder(this.cibProfile));
        p.addLast("toMessage", (ChannelHandler)new Object2Message());
        p.addLast(new IdleStateHandler(readerIdleTimeSeconds, writerIdleTimeSeconds, allIdleTimeSeconds));
        p.addLast(new TimeoutHandler());
    }
}

