/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.gm.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import javax.annotation.Resource;
import netbank.firm.config.HsmConfig;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.DcfirmRTException;
import netbank.firm.gm.HsmService;
import netbank.firm.gm.constant.HsmCommandCode;
import netbank.firm.gm.protocol.HsmMessage;
import netbank.firm.gm.protocol.req.ExportSM2KeypairReq;
import netbank.firm.gm.protocol.req.GenSM2KeypairReq;
import netbank.firm.gm.protocol.req.ImportSM2KeypairReq;
import netbank.firm.gm.protocol.req.QuerySM2KeypairIndexesReq;
import netbank.firm.gm.protocol.req.SM2DecryptReq;
import netbank.firm.gm.protocol.req.SM2EncryptReq;
import netbank.firm.gm.protocol.req.SM2ToSM4Req;
import netbank.firm.gm.protocol.req.SM3GetResultReq;
import netbank.firm.gm.protocol.req.SM3InitialReq;
import netbank.firm.gm.protocol.req.SM3UpdateReq;
import netbank.firm.gm.protocol.req.SM4DecryptReq;
import netbank.firm.gm.protocol.req.SM4EncryptReq;
import netbank.firm.gm.protocol.req.TestHsmReq;
import netbank.firm.gm.protocol.resp.ErrorMessageResp;
import netbank.firm.gm.protocol.resp.ExportSM2KeypairResp;
import netbank.firm.gm.protocol.resp.GenSM2KeypairResp;
import netbank.firm.gm.protocol.resp.QuerySM2KeypairIndexesResp;
import netbank.firm.gm.protocol.resp.ResponseHead;
import netbank.firm.gm.protocol.resp.SM2DecryptResp;
import netbank.firm.gm.protocol.resp.SM2EncryptResp;
import netbank.firm.gm.protocol.resp.SM2ToSM4Resp;
import netbank.firm.gm.protocol.resp.SM3GetResultResp;
import netbank.firm.gm.protocol.resp.SM3InitialResp;
import netbank.firm.gm.protocol.resp.SM3UpdateResp;
import netbank.firm.gm.protocol.resp.SM4DecryptResp;
import netbank.firm.gm.protocol.resp.SM4EncryptResp;
import netbank.firm.gm.utils.Base64;
import netbank.firm.gm.utils.ConvertUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import shade.org.apache.commons.lang.StringUtils;
import shaded.org.bouncycastle.util.encoders.Hex;

public class HsmServiceImpl
implements HsmService {
    public static final Integer SM3_MAX_FRAGMENT = 65165;
    @Resource(name="hsmConfig")
    private HsmConfig hsmConfig;
    private static final Log LOG = LogFactory.getLog(HsmServiceImpl.class);

    public ExportSM2KeypairResp exportSM2Keypair(ExportSM2KeypairReq req) throws DcfirmException {
        return (ExportSM2KeypairResp)this.process(req);
    }

    public GenSM2KeypairResp genSM2Keypair(GenSM2KeypairReq req) throws DcfirmException {
        return (GenSM2KeypairResp)this.process(req);
    }

    public ResponseHead importSM2Keypair(ImportSM2KeypairReq req) throws DcfirmException {
        return (ResponseHead)this.process(req);
    }

    public QuerySM2KeypairIndexesResp querySM2KeypairIndexes(QuerySM2KeypairIndexesReq req) throws DcfirmException {
        return (QuerySM2KeypairIndexesResp)this.process(req);
    }

    public SM2DecryptResp SM2Decrypt(String sm2EncText) throws DcfirmException {
        SM2DecryptReq req = new SM2DecryptReq();
        req.setIndex(this.hsmConfig.getSm2KeypairIndex());
        req.setPass(Base64.decode(this.hsmConfig.getSm2KeypairPass()));
        req.setSignedText(Base64.decode(sm2EncText));
        return this.SM2Decrypt(req);
    }

    private SM2DecryptResp SM2Decrypt(SM2DecryptReq req) throws DcfirmException {
        return (SM2DecryptResp)this.process(req);
    }

    public SM2EncryptResp SM2Encrypt(String plainText) throws DcfirmException {
        SM2EncryptReq req = new SM2EncryptReq();
        req.setIndex(this.hsmConfig.getSm2KeypairIndex());
        req.setPass(Base64.decode(this.hsmConfig.getSm2KeypairPass()));
        req.setSrcText(plainText.getBytes());
        return this.SM2Encrypt(req);
    }

    private SM2EncryptResp SM2Encrypt(SM2EncryptReq req) throws DcfirmException {
        return (SM2EncryptResp)this.process(req);
    }

    public SM2ToSM4Resp SM2ToSM4(String sm2EncText) throws DcfirmException {
        SM2ToSM4Req req = new SM2ToSM4Req();
        req.setFromKeyIdx(this.hsmConfig.getSm2KeypairIndex());
        req.setPass(this.hsmConfig.getSm2KeypairPass().getBytes());
        req.setToKeyIdx(this.hsmConfig.getSm4KeyIndex());
        req.setSm2EncText(Hex.decode(sm2EncText));
        return this.SM2ToSM4(req);
    }

    private SM2ToSM4Resp SM2ToSM4(SM2ToSM4Req req) throws DcfirmException {
        return (SM2ToSM4Resp)this.process(req);
    }

    public SM4DecryptResp SM4Decrypt(String sm4EncText) throws DcfirmException {
        SM4DecryptReq req = new SM4DecryptReq();
        req.setKeyIdx(this.hsmConfig.getSm4KeyIndex());
        req.setEncText(Base64.decode(sm4EncText));
        return this.SM4Decrypt(req);
    }

    private SM4DecryptResp SM4Decrypt(SM4DecryptReq req) throws DcfirmException {
        return (SM4DecryptResp)this.process(req);
    }

    public SM4EncryptResp SM4Encrypt(byte[] protocol) throws DcfirmException {
        SM4EncryptReq req = new SM4EncryptReq();
        req.setKeyIdx(this.hsmConfig.getSm4KeyIndex());
        req.setPlainText(protocol);
        return this.SM4Encrypt(req);
    }

    private SM4EncryptResp SM4Encrypt(SM4EncryptReq req) throws DcfirmException {
        return (SM4EncryptResp)this.process(req);
    }

    public ResponseHead testHsm() throws DcfirmException {
        TestHsmReq req = new TestHsmReq();
        return (ResponseHead)this.process(req);
    }

    public byte[] constructProtocol(String rawPwd) throws DcfirmException {
        if (StringUtils.isEmpty(rawPwd)) {
            throw new DcfirmException("14108", "\u6784\u5efa\u6d88\u606f\u534f\u8bae\u5931\u8d25\uff0c\u5bc6\u7801\u539f\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rawPwd.length() > HsmConfig.RAWPASS_MAX_LENGTH) {
            throw new DcfirmException("14109", "\u6784\u5efa\u6d88\u606f\u534f\u8bae\u5931\u8d25\uff0c\u5bc6\u7801\u539f\u6587\u8d85\u8fc7120\u4f4d");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[HsmConfig.PROTOCOL_FIX_LENGTH.intValue()]);
        byte[] lengthByte = ConvertUtil.IntegerToLengthBytes(rawPwd.length());
        byteBuffer.put(lengthByte);
        byteBuffer.put(rawPwd.getBytes());
        Integer padLength = HsmConfig.PROTOCOL_FIX_LENGTH - 2 - rawPwd.length();
        byte[] pad = new byte[padLength.intValue()];
        for (int i = 0; i < padLength; ++i) {
            pad[i] = 97;
        }
        byteBuffer.put(pad);
        return byteBuffer.array();
    }

    public String parseProtocol(byte[] protocol) throws DcfirmException {
        if (null == protocol || protocol.length == 0) {
            throw new DcfirmException("14110", "\u89e3\u6790\u6d88\u606f\u534f\u8bae\u5931\u8d25\uff0c\u6d88\u606f\u534f\u8bae\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (protocol.length != HsmConfig.PROTOCOL_FIX_LENGTH) {
            throw new DcfirmException("14111", "\u89e3\u6790\u6d88\u606f\u534f\u8bae\u5931\u8d25\uff0c\u6d88\u606f\u534f\u8bae\u957f\u5ea6\u4e0d\u6b63\u786e");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(protocol);
        byte[] passLengthByte = new byte[2];
        byteBuffer.get(passLengthByte, 0, 2);
        Integer rawPassLength = ConvertUtil.lengthBytesToInteger(passLengthByte);
        if (rawPassLength > HsmConfig.RAWPASS_MAX_LENGTH) {
            throw new DcfirmException("14109", "\u89e3\u6790\u6d88\u606f\u534f\u8bae\u5931\u8d25\uff0c\u539f\u59cb\u5bc6\u7801\u957f\u5ea6\u8d85\u8fc780\u4f4d");
        }
        byte[] rawPassByte = new byte[rawPassLength.intValue()];
        byteBuffer.get(rawPassByte, 0, rawPassLength);
        return new String(rawPassByte);
    }

    public String SM3Encrypt(byte[] bodyBytes) throws DcfirmException {
        if (null == bodyBytes) {
            throw new DcfirmException("14108", "sm3: \u786c\u4ef6\u52a0\u5bc6\u673a\u5bc6\u7801\u539f\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int length = bodyBytes.length;
        SM3InitialReq sm3InitialReq = new SM3InitialReq();
        SM3InitialResp sm3InitialResp = this.sm3Initial(sm3InitialReq);
        int count = length / SM3_MAX_FRAGMENT;
        int remainder = length % SM3_MAX_FRAGMENT;
        if (count == 0 || count == 1 && remainder == 0) {
            SM3UpdateReq sm3UpdateReq = new SM3UpdateReq();
            SM3UpdateResp sm3UpdateResp = this.sm3UpdateResp(sm3UpdateReq, sm3InitialResp, (Integer)length, bodyBytes);
            SM3GetResultReq sm3GetResultReq = new SM3GetResultReq();
            SM3GetResultResp sm3GetResultResp = this.sm3GetResultResp(sm3GetResultReq, sm3UpdateResp);
            return sm3GetResultResp.getHexString();
        }
        SM3UpdateReq sm3UpdateReq = new SM3UpdateReq();
        SM3UpdateResp sm3UpdateResp = new SM3UpdateResp();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bodyBytes);
        for (int i = 0; i < count; ++i) {
            byte[] tempBytes = new byte[SM3_MAX_FRAGMENT.intValue()];
            byteBuffer.get(tempBytes, 0, SM3_MAX_FRAGMENT);
            sm3UpdateResp = i == 0 ? this.sm3UpdateResp(sm3UpdateReq, sm3InitialResp, SM3_MAX_FRAGMENT, tempBytes) : this.sm3UpdateResp(sm3UpdateReq, sm3UpdateResp, SM3_MAX_FRAGMENT, tempBytes);
        }
        if (remainder != 0) {
            byte[] tempBytes = new byte[remainder];
            byteBuffer.get(tempBytes, 0, remainder);
            sm3UpdateResp = this.sm3UpdateResp(sm3UpdateReq, sm3UpdateResp, (Integer)remainder, tempBytes);
        }
        SM3GetResultReq sm3GetResultReq = new SM3GetResultReq();
        SM3GetResultResp sm3GetResultResp = this.sm3GetResultResp(sm3GetResultReq, sm3UpdateResp);
        return sm3GetResultResp.getHexString();
    }

    private SM3InitialResp sm3Initial(SM3InitialReq sm3InitialReq) throws DcfirmException {
        return (SM3InitialResp)this.process(sm3InitialReq);
    }

    private SM3UpdateResp sm3UpdateResp(SM3UpdateReq sm3UpdateReq, SM3InitialResp sm3InitialResp, Integer dataLength, byte[] dataBytes) throws DcfirmException {
        Integer contextLength = sm3InitialResp.getSm3Context().length;
        sm3UpdateReq.setContextLength(contextLength);
        sm3UpdateReq.setContext(sm3InitialResp.getSm3Context());
        sm3UpdateReq.setDataLength(dataLength);
        sm3UpdateReq.setData(dataBytes);
        return (SM3UpdateResp)this.process(sm3UpdateReq);
    }

    private SM3UpdateResp sm3UpdateResp(SM3UpdateReq sm3UpdateReq, SM3UpdateResp sm3UpdateResp, Integer dataLength, byte[] dataBytes) throws DcfirmException {
        Integer contextLength = sm3UpdateResp.getSm3Context().length;
        sm3UpdateReq.setContextLength(contextLength);
        sm3UpdateReq.setContext(sm3UpdateResp.getSm3Context());
        sm3UpdateReq.setDataLength(dataLength);
        sm3UpdateReq.setData(dataBytes);
        return (SM3UpdateResp)this.process(sm3UpdateReq);
    }

    private SM3GetResultResp sm3GetResultResp(SM3GetResultReq sm3GetResultReq, SM3UpdateResp sm3UpdateResp) throws DcfirmException {
        sm3GetResultReq.setContextWithLength(sm3UpdateResp.getSm3Context());
        return (SM3GetResultResp)this.process(sm3GetResultReq);
    }

    private Integer getLength(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byte[] passLengthByte = new byte[2];
        byteBuffer.get(passLengthByte, 0, 2);
        return ConvertUtil.byteToShort(passLengthByte);
    }

    private HsmMessage process(HsmMessage req) throws DcfirmException {
        Socket socket = null;
        FilterInputStream is = null;
        FilterOutputStream os = null;
        HsmCommandCode hsmCommandCode = req.getHsmCommandCode();
        try {
            socket = new Socket();
            socket.setSoTimeout(this.hsmConfig.getHsmReadTimeout());
            socket.connect(new InetSocketAddress(this.hsmConfig.getHsmHost(), (int)this.hsmConfig.getHsmPort()), this.hsmConfig.getHsmConnTimeout());
            is = new DataInputStream(socket.getInputStream());
            os = new DataOutputStream(socket.getOutputStream());
            try {
                os.write(req.serialize());
                ((DataOutputStream)os).flush();
            }
            catch (IOException e) {
                LOG.error("\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u53d1\u9001\u6d88\u606f\u5931\u8d25, typeCode = [" + (Object)((Object)req.getHsmCommandCode()) + "]");
                throw new DcfirmRTException("14105", "\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u53d1\u9001\u6d88\u606f\u5931\u8d25", e);
            }
            ByteBuffer readBuffer = null;
            try {
                readBuffer = ByteBuffer.allocate(HsmMessage.MSG_MAX_SIZE);
                ((DataInputStream)is).read(readBuffer.array());
            }
            catch (IOException e) {
                LOG.error("\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u63a5\u6536\u6d88\u606f\u5931\u8d25, typeCode = [" + (Object)((Object)req.getHsmCommandCode()) + "]", e);
                throw new DcfirmRTException("14105", "\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u63a5\u6536\u6d88\u606f\u5931\u8d25", e);
            }
            if (!HsmMessage.success(readBuffer).booleanValue()) {
                ErrorMessageResp error = HsmMessage.deserializeError(readBuffer);
                Assert.notNull((Object)req.getHsmCommandCode().getCode(), "");
                LOG.error("\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u9519\u8bef, typeCode = [" + (Object)((Object)req.getHsmCommandCode()) + "], errCode = [" + error.toHexString() + "]");
                throw new DcfirmException("14102", "\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u9519\u8bef\uff0c\u9519\u8bef\u7801:[" + error.toHexString() + "]");
            }
            HsmMessage hsmMessage = HsmMessage.deserializeMsg(readBuffer, hsmCommandCode);
            return hsmMessage;
        }
        catch (IOException e) {
            throw new DcfirmRTException("14101", "\u8fde\u63a5\u786c\u4ef6\u52a0\u5bc6\u673a\u5f02\u5e38", e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {
                LOG.error("\u5173\u95ed\u786c\u4ef6\u52a0\u5bc6\u673a\u8fde\u63a5\u5f02\u5e38", e);
            }
        }
    }

    public String SM3EncryptSpec(byte[] bodyBytes) throws DcfirmException, DcfirmRTException {
        return this.processForSm3(bodyBytes);
    }

    private String processForSm3(byte[] bodyBytes) throws DcfirmException, DcfirmRTException {
        if (null == bodyBytes) {
            throw new DcfirmException("14108", "sm3: \u786c\u4ef6\u52a0\u5bc6\u673a\u5bc6\u7801\u539f\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int length = bodyBytes.length;
        Socket socket = null;
        FilterInputStream is = null;
        FilterOutputStream os = null;
        try {
            try {
                socket = new Socket();
                socket.setSoTimeout(this.hsmConfig.getHsmReadTimeout());
                socket.connect(new InetSocketAddress(this.hsmConfig.getHsmHost(), (int)this.hsmConfig.getHsmPort()), this.hsmConfig.getHsmConnTimeout());
                is = new DataInputStream(socket.getInputStream());
                os = new DataOutputStream(socket.getOutputStream());
            }
            catch (IOException e) {
                LOG.error("\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u53d1\u9001\u6d88\u606f\u5931\u8d25, \u8fde\u63a5\u52a0\u5bc6\u673a\u51fa\u73b0\u5f02\u5e38:", e);
                throw new DcfirmRTException("14101", "\u8fde\u63a5\u52a0\u5bc6\u673a\u51fa\u73b0\u5f02\u5e38", e);
            }
            SM3InitialReq sm3InitialReq = new SM3InitialReq();
            SM3InitialResp sm3InitialResp = (SM3InitialResp)this.sendToHsm(sm3InitialReq, (DataInputStream)is, (DataOutputStream)os);
            int count = length / SM3_MAX_FRAGMENT;
            int remainder = length % SM3_MAX_FRAGMENT;
            if (count == 0 || count == 1 && remainder == 0) {
                SM3UpdateReq sm3UpdateReq = new SM3UpdateReq();
                Integer contextLength = sm3InitialResp.getSm3Context().length;
                sm3UpdateReq.setContextLength(contextLength);
                sm3UpdateReq.setContext(sm3InitialResp.getSm3Context());
                sm3UpdateReq.setDataLength(length);
                sm3UpdateReq.setData(bodyBytes);
                SM3UpdateResp sm3UpdateResp = (SM3UpdateResp)this.sendToHsm(sm3UpdateReq, (DataInputStream)is, (DataOutputStream)os);
                SM3GetResultReq sm3GetResultReq = new SM3GetResultReq();
                sm3GetResultReq.setContextWithLength(sm3UpdateResp.getSm3Context());
                SM3GetResultResp sm3GetResultResp = (SM3GetResultResp)this.sendToHsm(sm3GetResultReq, (DataInputStream)is, (DataOutputStream)os);
                String string = sm3GetResultResp.getHexString();
                return string;
            }
            SM3UpdateReq sm3UpdateReq = new SM3UpdateReq();
            SM3UpdateResp sm3UpdateResp = new SM3UpdateResp();
            ByteBuffer byteBuffer = ByteBuffer.wrap(bodyBytes);
            for (int i = 0; i < count; ++i) {
                Integer contextLength;
                byte[] tempBytes = new byte[SM3_MAX_FRAGMENT.intValue()];
                byteBuffer.get(tempBytes, 0, SM3_MAX_FRAGMENT);
                if (i == 0) {
                    contextLength = sm3InitialResp.getSm3Context().length;
                    sm3UpdateReq.setContextLength(contextLength);
                    sm3UpdateReq.setContext(sm3InitialResp.getSm3Context());
                    sm3UpdateReq.setDataLength(SM3_MAX_FRAGMENT);
                    sm3UpdateReq.setData(tempBytes);
                    sm3UpdateResp = (SM3UpdateResp)this.sendToHsm(sm3UpdateReq, (DataInputStream)is, (DataOutputStream)os);
                    continue;
                }
                contextLength = sm3UpdateResp.getSm3Context().length;
                sm3UpdateReq.setContextLength(contextLength);
                sm3UpdateReq.setContext(sm3UpdateResp.getSm3Context());
                sm3UpdateReq.setDataLength(SM3_MAX_FRAGMENT);
                sm3UpdateReq.setData(tempBytes);
                sm3UpdateResp = (SM3UpdateResp)this.sendToHsm(sm3UpdateReq, (DataInputStream)is, (DataOutputStream)os);
            }
            if (remainder != 0) {
                byte[] tempBytes = new byte[remainder];
                byteBuffer.get(tempBytes, 0, remainder);
                Integer contextLength = sm3UpdateResp.getSm3Context().length;
                sm3UpdateReq.setContextLength(contextLength);
                sm3UpdateReq.setContext(sm3UpdateResp.getSm3Context());
                sm3UpdateReq.setDataLength(remainder);
                sm3UpdateReq.setData(tempBytes);
                sm3UpdateResp = (SM3UpdateResp)this.sendToHsm(sm3UpdateReq, (DataInputStream)is, (DataOutputStream)os);
            }
            SM3GetResultReq sm3GetResultReq = new SM3GetResultReq();
            sm3GetResultReq.setContextWithLength(sm3UpdateResp.getSm3Context());
            SM3GetResultResp sm3GetResultResp = (SM3GetResultResp)this.sendToHsm(sm3GetResultReq, (DataInputStream)is, (DataOutputStream)os);
            String string = sm3GetResultResp.getHexString();
            return string;
        }
        catch (DcfirmRTException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u53d1\u9001\u6d88\u606f\u5931\u8d25, \u52a0\u5bc6\u51fa\u73b0\u5f02\u5e38");
            throw new DcfirmRTException("14101", "\u52a0\u5bc6\u51fa\u73b0\u5f02\u5e38", e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                if (socket != null && !socket.isClosed()) {
                    socket.close();
                }
            }
            catch (IOException e) {
                LOG.error("\u5173\u95ed\u786c\u4ef6\u52a0\u5bc6\u673a\u8fde\u63a5\u5f02\u5e38", e);
            }
        }
    }

    private HsmMessage sendToHsm(HsmMessage req, DataInputStream is, DataOutputStream os) throws DcfirmException, DcfirmRTException {
        HsmCommandCode hsmCommandCode = req.getHsmCommandCode();
        try {
            os.write(req.serialize());
            os.flush();
        }
        catch (IOException e) {
            LOG.error("\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u53d1\u9001\u6d88\u606f\u5931\u8d25, typeCode = [" + (Object)((Object)req.getHsmCommandCode()) + "]");
            throw new DcfirmRTException("14105", "\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u53d1\u9001\u6d88\u606f\u5931\u8d25", e);
        }
        ByteBuffer readBuffer = null;
        try {
            readBuffer = ByteBuffer.allocate(HsmMessage.MSG_MAX_SIZE);
            is.read(readBuffer.array());
        }
        catch (IOException e) {
            LOG.error("\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u63a5\u6536\u6d88\u606f\u5931\u8d25, typeCode = [" + (Object)((Object)req.getHsmCommandCode()) + "]", e);
            throw new DcfirmRTException("14105", "\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u63a5\u6536\u6d88\u606f\u5931\u8d25", e);
        }
        if (!HsmMessage.success(readBuffer).booleanValue()) {
            ErrorMessageResp error = HsmMessage.deserializeError(readBuffer);
            Assert.notNull((Object)req.getHsmCommandCode().getCode(), "");
            LOG.error("\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u9519\u8bef, typeCode = [" + (Object)((Object)req.getHsmCommandCode()) + "], errCode = [" + error.toHexString() + "]");
            throw new DcfirmException("14102", "\u8c03\u7528\u786c\u4ef6\u52a0\u5bc6\u673a\u9519\u8bef\uff0c\u9519\u8bef\u7801:[" + error.toHexString() + "]");
        }
        return HsmMessage.deserializeMsg(readBuffer, hsmCommandCode);
    }
}

