/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.org.apache.commons.lang3.StringUtils;

public class GzipUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(GzipUtil.class);

    public static void gzip(String infile) throws DcfirmException {
        if (infile == null || infile.trim().equals("")) {
            LOG.error("gzip\u6e90\u6587\u4ef6\u540d\u4e3a\u7a7a");
            throw new DcfirmException(ExceptionCode.U100);
        }
        infile = infile.trim();
        GzipUtil.gzip(infile, infile + ".gz");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void gzip(String infile, String outfile) throws DcfirmException {
        LOG.debug("gzip\u5f00\u59cb...");
        if (infile == null || infile.trim().equals("")) {
            LOG.error("gzip\u6e90\u6587\u4ef6\u540d\u4e3a\u7a7a!");
            throw new DcfirmException(ExceptionCode.U100);
        }
        if (outfile == null || outfile.trim().equals("")) {
            LOG.error("gzip\u76ee\u6807\u6587\u4ef6\u540d\u4e3a\u7a7a!");
            throw new DcfirmException(ExceptionCode.U100);
        }
        if (!new File(infile).canRead()) {
            LOG.error("gzip\u6e90\u6587\u4ef6\u4e0d\u53ef\u8bfb!");
            throw new DcfirmException(ExceptionCode.U101);
        }
        infile = infile.trim();
        outfile = outfile.trim();
        FileInputStream fin = null;
        FileOutputStream fout = null;
        DeflaterOutputStream gzout = null;
        String tmpfile = null;
        try {
            try {
                int num;
                tmpfile = outfile;
                if (infile.equals(outfile)) {
                    tmpfile = outfile + ".gz.cdptmp";
                    new File(tmpfile).delete();
                }
                fin = new FileInputStream(infile);
                fout = new FileOutputStream(tmpfile);
                gzout = new GZIPOutputStream(fout);
                byte[] buf = new byte[1024];
                while ((num = fin.read(buf)) != -1) {
                    ((GZIPOutputStream)gzout).write(buf, 0, num);
                }
                gzout.close();
                gzout = null;
                fout.close();
                fin.close();
                if (infile.equals(outfile)) {
                    new File(infile).delete();
                    new File(tmpfile).renameTo(new File(infile));
                }
                LOG.debug("gzip\u6210\u529f...");
            }
            catch (IOException e) {
                new File(tmpfile).delete();
                throw new DcfirmException(ExceptionCode.U103);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (gzout != null) {
                    gzout.close();
                }
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fout.close();
                }
                if (!infile.equals(outfile)) throw throwable;
                new File(tmpfile).delete();
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("gzip\u538b\u7f29\u5931\u8d25:\u6587\u4ef6=[" + infile + "],\u538b\u7f29\u6587\u4ef6=[" + outfile + "]");
                throw new DcfirmException(ExceptionCode.U103);
            }
        }
        try {}
        catch (IOException e) {
            LOG.error("gzip\u538b\u7f29\u5931\u8d25:\u6587\u4ef6=[" + infile + "],\u538b\u7f29\u6587\u4ef6=[" + outfile + "]");
            throw new DcfirmException(ExceptionCode.U103);
        }
        if (gzout != null) {
            gzout.close();
        }
        if (fin != null) {
            fin.close();
        }
        if (fout != null) {
            fout.close();
        }
        if (!infile.equals(outfile)) return;
        new File(tmpfile).delete();
    }

    public static boolean isFileGzZip(String infile) {
        if (StringUtils.isBlank(infile)) {
            return false;
        }
        String trimFileName = infile.trim();
        return trimFileName.endsWith(".gz");
    }

    public static void gunzip(String infile) throws DcfirmException {
        if (infile == null || infile.trim().equals("")) {
            LOG.error("gunzip\u6e90\u6587\u4ef6\u540d\u4e3a\u7a7a");
            throw new DcfirmException(ExceptionCode.U100);
        }
        String trimFileName = infile.trim();
        if (infile.contains("!")) {
            infile.replaceAll("!", "\\!");
        }
        if (!trimFileName.substring(trimFileName.length() - 3).equals(".gz")) {
            LOG.error("gunzip\u6e90\u6587\u4ef6\u540d\u4e0d\u6b63\u786e");
            throw new DcfirmException(ExceptionCode.U100);
        }
        GzipUtil.gunzip(infile, trimFileName.substring(0, trimFileName.length() - 3));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void gunzip(String infile, String outfile) throws DcfirmException {
        LOG.debug("gunzip\u5f00\u59cb...");
        if (infile == null || infile.trim().equals("")) {
            LOG.error("gunzip\u6e90\u6587\u4ef6\u540d\u4e3a\u7a7a");
            throw new DcfirmException(ExceptionCode.U100);
        }
        if (outfile == null || outfile.trim().equals("")) {
            LOG.error("gunzip\u76ee\u6807\u6587\u4ef6\u540d\u4e3a\u7a7a");
            throw new DcfirmException(ExceptionCode.U100);
        }
        if (!new File(infile).canRead()) {
            LOG.error("gunzip\u6e90\u6587\u4ef6\u540d\u4e0d\u5b58\u5728");
            throw new DcfirmException(ExceptionCode.U101);
        }
        FileInputStream fin = null;
        GZIPInputStream gzin = null;
        FileOutputStream fout = null;
        String tmpfile = null;
        try {
            try {
                int num;
                tmpfile = outfile;
                if (infile.equals(outfile)) {
                    tmpfile = outfile + ".cdptmp";
                    new File(tmpfile).delete();
                }
                fin = new FileInputStream(infile);
                gzin = new GZIPInputStream(fin);
                fout = new FileOutputStream(tmpfile);
                byte[] buf = new byte[1024];
                while ((num = gzin.read(buf, 0, buf.length)) != -1) {
                    fout.write(buf, 0, num);
                }
                gzin.close();
                fout.close();
                fin.close();
                if (infile.equals(outfile)) {
                    new File(infile).delete();
                    new File(tmpfile).renameTo(new File(infile));
                }
                LOG.debug("gunzip\u6210\u529f...");
            }
            catch (IOException e) {
                new File(tmpfile).delete();
                throw new DcfirmException(ExceptionCode.U104);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (gzin != null) {
                    gzin.close();
                }
                if (fout != null) {
                    fout.close();
                }
                if (fin != null) {
                    fin.close();
                }
                if (!infile.equals(outfile)) throw throwable;
                new File(tmpfile).delete();
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("gunzip\u89e3\u538b\u7f29\u5931\u8d25:\u6587\u4ef6=[" + infile + "],\u89e3\u538b\u7f29\u6587\u4ef6=[" + outfile + "]");
                throw new DcfirmException(ExceptionCode.U104);
            }
        }
        try {}
        catch (IOException e) {
            LOG.error("gunzip\u89e3\u538b\u7f29\u5931\u8d25:\u6587\u4ef6=[" + infile + "],\u89e3\u538b\u7f29\u6587\u4ef6=[" + outfile + "]");
            throw new DcfirmException(ExceptionCode.U104);
        }
        if (gzin != null) {
            gzin.close();
        }
        if (fout != null) {
            fout.close();
        }
        if (fin != null) {
            fin.close();
        }
        if (!infile.equals(outfile)) return;
        new File(tmpfile).delete();
    }
}

