/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.springframework.util.Assert;

public class CompressionUtil {
    private static final int BUFFER_SIZE = 4096;

    public static byte[] compress(byte[] data) throws IOException {
        return CompressionUtil.compress(data, Level.BEST_SPEED);
    }

    public static byte[] compress(byte[] data, Level level) throws IOException {
        Assert.notNull(data);
        Assert.notNull((Object)level);
        Deflater deflater = new Deflater();
        deflater.setLevel(level.getLevel());
        deflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        deflater.finish();
        byte[] buffer = new byte[4096];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        byte[] output = outputStream.toByteArray();
        outputStream.close();
        return output;
    }

    public static byte[] decompress(byte[] data) throws IOException, DataFormatException {
        Assert.notNull(data);
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[4096];
        while (!inflater.finished()) {
            int count = inflater.inflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        byte[] output = outputStream.toByteArray();
        outputStream.close();
        return output;
    }

    public static void main(String[] args) throws Exception {
        String str = "\u5728\u4fe1\u606f\u79d1\u6280\u90e8\u53ca\u603b\u5206\u884c\u4e1a\u52a1\u90e8\u95e8\u7684\u5927\u529b\u652f\u6301\u4e0b\uff0c\u73b0\u91d1\u7ba1\u7406\u7cfb\u7edf\u4e00\u671f\u9879\u76ee\u4e8e4\u67083\u65e5\u987a\u5229\u4e0a\u7ebf, \u6807\u5fd7\u7740\u672c\u884c\u8de8\u5883\u91d1\u878d\u4e1a\u52a1\u53d6\u5f97\u91cd\u5927\u7a81\u7834\uff0c\u5bf9\u6211\u884c\u652f\u6301\u4e00\u5e26\u4e00\u8def\u8d77\u5230\u5173\u952e\u4f5c\u7528\u3002\u4e3a\u66f4\u597d\u52a9\u529b\u4e2d\u8d44\u4f01\u4e1a\u201c\u8d70\u51fa\u53bb\u201d\uff0c\u5916\u8d44\u8de8\u56fd\u516c\u53f8\u201c\u8d70\u8fdb\u6765\u201d\uff0c\u81ea2014\u5e7411\u6708\u592e\u884c\u53d1\u5e03\u300a\u5173\u4e8e\u8de8\u56fd\u4f01\u4e1a\u96c6\u56e2\u5f00\u5c55\u8de8\u5883\u4eba\u6c11\u5e01\u8d44\u91d1\u96c6\u4e2d\u8fd0\u8425\u4e1a\u52a1\u6709\u5173\u4e8b\u5b9c\u7684\u901a\u77e5\u300b\uff0c\u53ca\u672c\u884c\u4e0a\u6d77\u81ea\u8d38\u533a\u7cfb\u7edf\u901a\u8fc7\u9a8c\u6536\uff0c\u798f\u5efa\u3001\u5e7f\u4e1c\u3001\u5929\u6d25\u81ea\u8d38\u533a\u83b7\u6279\uff0c\u8de8\u5883\u53cc\u5411\u4eba\u6c11\u5e01\u8d44\u91d1\u6c60\uff08\u7b80\u79f0\u8de8\u5883\u4eba\u6c11\u5e01\u8d44\u91d1\u6c60\uff09\u76f8\u5173\u529f\u80fd\u7684\u5efa\u8bbe\u8feb\u5728\u7709\u776b\u3002\u968f\u7740\u5229\u7387\u5e02\u573a\u5316\u8fdb\u7a0b\u52a0\u901f\uff0c\u539f\u6765\u7531\u4e8e\u8ba1\u606f\u65b9\u5f0f\uff08\u5408\u5e76\u8ba1\u606f\uff09\u5b58\u5728\u6cd5\u5f8b\u969c\u788d\u7684\u865a\u62df\u8d44\u91d1\u6c60\uff08\u53c8\u79f0\u540d\u4e49\u8d44\u91d1\u6c60\uff09\u5df2\u65e0\u76f8\u5173\u6cd5\u5f8b\u969c\u788d\uff0c\u540c\u65f6\u7531\u4e8e\u5176\u4e0d\u53d1\u751f\u5b9e\u9645\u7684\u8d44\u91d1\u5f52\u96c6\uff0c\u5bf9\u7ed3\u6784\u677e\u6563\u578b\u6216\u8005\u884c\u4e1a\u8de8\u5ea6\u8f83\u5927\u7684\u4f01\u4e1a\u66f4\u4e3a\u5408\u9002\uff1a\u6ca1\u6709\u8d44\u91d1\u5f52\u96c6\u7684\u8d39\u7528\uff0c\u8282\u7ea6\u4e86\u4f01\u4e1a\u6210\u672c\uff1b\u6ca1\u6709\u6bcd\u5b50\u516c\u53f8\u4e4b\u95f4\u7684\u5b9e\u9645\u8d44\u91d1\u5212\u62e8\uff0c\u65e0\u4e0d\u540c\u5b9e\u4f53\u4e4b\u95f4\u7684\u8d44\u91d1\u7684\u8f6c\u79fb\u6240\u5e26\u6765\u7684\u6cd5\u5f8b\u95ee\u9898\uff0c\u662f\u5927\u578b\u96c6\u56e2\u516c\u53f8\u8fdb\u884c\u8d44\u91d1\u96c6\u4e2d\u7ba1\u7406\u7684\u5229\u5668\uff0c\u4e5f\u5c06\u6210\u4e3a\u672c\u884c\u9488\u5bf9\u96c6\u56e2\u5ba2\u6237\u63a8\u51fa\u7684\u6781\u6709\u5438\u5f15\u529b\u3001\u6781\u5177\u653b\u51fb\u6027\u7684\u73b0\u91d1\u7ba1\u7406\u62f3\u5934\u4ea7\u54c1\u3002";
        byte[] by = CompressionUtil.compress(str.getBytes("GBK"), Level.BEST_COMPRESSION);
        System.out.println(by.length);
        by = CompressionUtil.decompress(by);
        System.out.println(by.length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        NO_COMPRESSION(0),
        BEST_SPEED(1),
        BEST_COMPRESSION(9),
        DEFAULT_COMPRESSION(-1);

        private int level;

        private Level(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

