/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.base;

import java.security.PrivateKey;
import netbank.firm.config.CibProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.cfca.sadk.algorithm.sm2.SM2PrivateKey;
import shaded.cfca.sadk.lib.crypto.JCrypto;
import shaded.cfca.sadk.lib.crypto.Session;
import shaded.cfca.sadk.util.CertUtil;
import shaded.cfca.sadk.util.KeyUtil;
import shaded.cfca.sadk.util.Signature;
import shaded.cfca.sadk.x509.certificate.X509Cert;

public class CFCASignature {
    private static Logger log = LoggerFactory.getLogger(CFCASignature.class);
    private CibProfile profile;
    private static Session session = null;
    private static final String DOT = ".";
    private static final String PFX_EXT_NAME = "pfx";
    private static final String SM2_EXT_NAME = "sm2";

    public String signature(String sourceData) throws Exception {
        if (sourceData == null) {
            throw new Exception("Signature source data is is null");
        }
        String extName = CFCASignature.extName(this.profile.getCertFilePath());
        try {
            if (PFX_EXT_NAME.equalsIgnoreCase(extName)) {
                PrivateKey ex = KeyUtil.getPrivateKeyFromPFX(this.profile.getCertFilePath(), this.profile.getCertPassword());
                X509Cert cert = CertUtil.getCertFromPFX(this.profile.getCertFilePath(), this.profile.getCertPassword());
                Signature sigUtil = new Signature();
                byte[] signature = sigUtil.p7SignMessageAttach("sha256WithRSAEncryption", sourceData.getBytes("UTF8"), ex, cert, session);
                return new String(signature, "UTF-8");
            }
            if (extName.equalsIgnoreCase(SM2_EXT_NAME)) {
                SM2PrivateKey ex = KeyUtil.getPrivateKeyFromSM2(this.profile.getCertFilePath(), this.profile.getCertPassword());
                X509Cert cert = CertUtil.getCertFromSM2(this.profile.getCertFilePath());
                Signature sigUtil = new Signature();
                byte[] signature = sigUtil.p7SignMessageAttach("sm3WithSM2Encryption", sourceData.getBytes("UTF8"), ex, cert, session);
                return new String(signature, "UTF-8");
            }
            throw new Exception("Error cert file :" + this.profile.getCertFilePath());
        }
        catch (Exception e) {
            log.error("signature error[" + sourceData + "]", e);
            throw e;
        }
    }

    public CibProfile getProfile() {
        return this.profile;
    }

    public void setProfile(CibProfile profile) {
        this.profile = profile;
    }

    private static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(DOT);
        if (index == -1) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    static {
        try {
            JCrypto ex = JCrypto.getInstance();
            ex.initialize("JSOFT_LIB", null);
            session = ex.openSession("JSOFT_LIB");
        }
        catch (Exception var1) {
            log.error("\u521d\u59cb\u5316CFCA\u7b7e\u540d\u52a0\u5bc6\u5e93\u5931\u8d25", var1);
        }
    }
}

