/*
 * Decompiled with CFR 0.152.
 */
package com.cib.smtools.util;

import com.cib.smtools.security.Base64;
import com.cib.smtools.security.CommonUtils;
import com.cib.smtools.security.SM2EngineExtend;
import com.cib.smtools.security.SM3Helper;
import com.cib.smtools.security.SM4Context;
import com.cib.smtools.security.SMS4;
import com.cib.smtools.sm.SM2;
import com.cib.smtools.sm.SM3;
import com.cib.smtools.sm.SM4;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import shaded.org.bouncycastle.asn1.gm.GMNamedCurves;
import shaded.org.bouncycastle.asn1.x9.X9ECParameters;
import shaded.org.bouncycastle.crypto.Digest;
import shaded.org.bouncycastle.crypto.digests.Blake2bDigest;
import shaded.org.bouncycastle.crypto.engines.SM2Engine;
import shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import shaded.org.bouncycastle.crypto.signers.StandardDSAEncoding;
import shaded.org.bouncycastle.math.ec.ECPoint;
import shaded.org.bouncycastle.util.encoders.Hex;

@Deprecated
public class SMUtil {
    private static final int NO_COMPRESS_LENGTH = 96;
    private static final String ALGORITHM = "sm2p256v1";
    private static final byte[] key = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -2, -36, -70, -104, 118, 84, 50, 16};
    private static SMS4 sms4 = null;
    private static com.cib.smtools.security.SM4 sm4 = null;
    private static SM4Context ctx = null;
    private static final ThreadLocal<SM2Engine> threadSM2Engine = new ThreadLocal();
    private static ECDomainParameters eCDomainParameters = null;
    private static final ThreadLocal<Map<String, SM2EngineExtend>> sm2EngineExendMapThread = new ThreadLocal();
    private static final int BLOCK_LENGTH = 64;
    private static String startKey = "";

    public static String sm4EcryptEBC(String strValue) {
        return SMUtil.sm4EcryptEBC(strValue, Charset.defaultCharset());
    }

    public static String sm4EcryptEBC(String strValue, Charset charset) {
        return SMUtil.sm4EncryptEBC(strValue, key, charset);
    }

    public static String sm4EcryptEBC(String strValue, String keystr) {
        return SMUtil.sm4EcryptEBC(strValue, keystr, Charset.defaultCharset());
    }

    private static String sm4EncryptEBC(String strValue, byte[] keyByte, Charset charset) {
        if (strValue == null) {
            return null;
        }
        String base64Str = new String(Base64.encode(strValue.getBytes(charset)), charset);
        base64Str = base64Str + "                ".substring(base64Str.getBytes(charset).length % 16);
        byte[] base64ValueBytes = base64Str.getBytes(charset);
        byte[] resultBytes = new byte[]{};
        try {
            resultBytes = SM4.encryptECB(base64ValueBytes, keyByte, "NOPADDING");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String(Base64.encode(resultBytes), charset);
    }

    public static String sm4EcryptEBC(String strValue, String keystr, Charset charset) {
        if (strValue == null) {
            return null;
        }
        String key64str = new String(Base64.encode(keystr.getBytes(charset)), charset);
        key64str = key64str + "                ".substring(key64str.getBytes(charset).length % 16);
        byte[] keyBytes = Arrays.copyOf(key64str.getBytes(charset), 16);
        return SMUtil.sm4EncryptEBC(strValue, keyBytes, charset);
    }

    public static String sm4DecryptEBC(String strValue) {
        return SMUtil.sm4DecryptEBC(strValue, Charset.defaultCharset());
    }

    public static String sm4DecryptEBC(String strValue, Charset charset) {
        return SMUtil.sm4DecryptEBC(strValue, key, charset);
    }

    public static String sm4DecryptEBC(String strValue, String keystr) {
        return SMUtil.sm4DecryptEBC(strValue, keystr, Charset.defaultCharset());
    }

    public static String sm4DecryptEBC(String strValue, String keystr, Charset charset) {
        if (strValue == null) {
            return null;
        }
        String keyBase64str = new String(Base64.encode(keystr.getBytes(charset)), charset);
        keyBase64str = keyBase64str + "                ".substring(keyBase64str.getBytes(charset).length % 16);
        byte[] keyBytes = Arrays.copyOf(keyBase64str.getBytes(charset), 16);
        return SMUtil.sm4DecryptEBC(strValue, keyBytes, charset);
    }

    private static String sm4DecryptEBC(String strValue, byte[] keyByte, Charset charset) {
        if (strValue == null) {
            return null;
        }
        byte[] valueBytes = Base64.decode(strValue.getBytes(charset));
        byte[] resultBytes = null;
        try {
            resultBytes = SM4.decryptECB(valueBytes, keyByte, "NOPADDING");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        resultBytes = resultBytes == null ? new byte[]{} : resultBytes;
        return new String(Base64.decode(resultBytes), charset);
    }

    public static String sm4EcryptCBC(String strValue) throws Exception {
        return SMUtil.sm4EcryptCBC(strValue, Charset.defaultCharset());
    }

    public static String sm4EcryptCBC(String strValue, Charset charset) throws Exception {
        if (strValue == null) {
            return null;
        }
        String newString = strValue.toString();
        String base64Str = new String(Base64.encode(newString.getBytes(charset)), charset);
        byte[] newIn = base64Str.getBytes(charset);
        SM4Context ctx = SMUtil.instanceSM4Context();
        ctx.setPadding(true);
        ctx.setMode(1);
        byte[] iv = "UISwD9fW6cFh9SNS".getBytes(charset);
        com.cib.smtools.security.SM4 sm4 = SMUtil.instanceSM4();
        sm4.sm4_setkey_enc(ctx, key);
        byte[] out = sm4.sm4_crypt_cbc(ctx, iv, newIn);
        byte[] res = Base64.encode(out);
        return new String(res, charset);
    }

    public static String sm4EcryptCBC(String strValue, String keystr) throws Exception {
        return SMUtil.sm4EcryptCBC(strValue, keystr, Charset.defaultCharset());
    }

    public static String sm4EcryptCBC(String strValue, String keystr, Charset charset) throws Exception {
        if (strValue == null) {
            return null;
        }
        com.cib.smtools.security.SM4 sm4 = SMUtil.instanceSM4();
        SM4Context ctx = SMUtil.instanceSM4Context();
        ctx.setPadding(true);
        ctx.setMode(1);
        String newString = strValue;
        String base64Str = new String(Base64.encode(newString.getBytes(charset)), charset);
        byte[] newIn = base64Str.getBytes(charset);
        sm4.sm4_setkey_enc(ctx, key);
        byte[] iv = keystr.getBytes(charset);
        byte[] out = sm4.sm4_crypt_cbc(ctx, iv, newIn);
        byte[] res = Base64.encode(out);
        return new String(res, charset);
    }

    public static String sm4DecryptCBC(String strValue) throws Exception {
        return SMUtil.sm4DecryptCBC(strValue, Charset.defaultCharset());
    }

    public static String sm4DecryptCBC(String strValue, Charset charset) throws Exception {
        if (strValue == null) {
            return null;
        }
        SM4Context ctx = SMUtil.instanceSM4Context();
        ctx.setPadding(true);
        ctx.setMode(0);
        com.cib.smtools.security.SM4 sm4 = SMUtil.instanceSM4();
        byte[] in = Base64.decode(strValue.getBytes(charset));
        sm4.sm4_setkey_dec(ctx, key);
        byte[] iv = "UISwD9fW6cFh9SNS".getBytes(charset);
        byte[] out = sm4.sm4_crypt_cbc(ctx, iv, in);
        byte[] newOut = Base64.decode(out);
        return new String(newOut, charset);
    }

    public static String sm4DecryptCBC(String strValue, String keystr) throws Exception {
        return SMUtil.sm4DecryptCBC(strValue, keystr, Charset.defaultCharset());
    }

    public static String sm4DecryptCBC(String strValue, String keystr, Charset charset) throws Exception {
        if (strValue == null) {
            return null;
        }
        SM4Context ctx = SMUtil.instanceSM4Context();
        ctx.setPadding(true);
        ctx.setMode(0);
        com.cib.smtools.security.SM4 sm4 = SMUtil.instanceSM4();
        byte[] in = Base64.decode(strValue.getBytes(charset));
        sm4.sm4_setkey_dec(ctx, key);
        byte[] iv = keystr.getBytes(charset);
        byte[] out = sm4.sm4_crypt_cbc(ctx, iv, in);
        byte[] newOut = Base64.decode(out);
        return new String(newOut, charset);
    }

    public static String sm3Ecrypt(String strValue) {
        return SMUtil.sm3Ecrypt(strValue, Charset.defaultCharset());
    }

    public static String sm3Ecrypt(String strValue, Charset charset) {
        if (strValue == null) {
            return null;
        }
        byte[] sm3HashValue = null;
        try {
            sm3HashValue = SM3.hash(strValue.getBytes(charset));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String(Base64.encode(sm3HashValue), charset);
    }

    public static String sm3EcryptHMAC(String text, String key) throws Exception {
        return SMUtil.sm3EcryptHMAC(text, key, Charset.defaultCharset());
    }

    public static String sm3EcryptHMAC(String text, String key, Charset charset) throws Exception {
        key = startKey + key;
        byte[] structured_key = new byte[64];
        byte[] IPAD = new byte[64];
        byte[] OPAD = new byte[64];
        if (key.getBytes(charset).length > 64) {
            byte[] sm3_key = SM3Helper.hash(key.getBytes(charset));
            System.arraycopy(sm3_key, 0, structured_key, 0, sm3_key.length);
        } else {
            System.arraycopy(key.getBytes(charset), 0, structured_key, 0, key.getBytes(charset).length);
        }
        for (int i = 0; i < 64; ++i) {
            IPAD[i] = 54;
            OPAD[i] = 92;
        }
        byte[] ipadkey = SMUtil.XOR(structured_key, IPAD);
        int textLen = text.getBytes(charset).length;
        byte[] t3 = new byte[64 + textLen];
        System.arraycopy(ipadkey, 0, t3, 0, ipadkey.length);
        System.arraycopy(text.getBytes(charset), 0, t3, ipadkey.length, text.getBytes(charset).length);
        byte[] t4 = SM3Helper.hash(t3);
        byte[] opadkey = SMUtil.XOR(structured_key, OPAD);
        byte[] t6 = new byte[64 + t4.length];
        System.arraycopy(opadkey, 0, t6, 0, opadkey.length);
        System.arraycopy(t4, 0, t6, opadkey.length, t4.length);
        String sm3HMACString = new String(Base64.encode(SM3Helper.hash(t6)), charset);
        return sm3HMACString;
    }

    public static byte[] XOR(byte[] key, byte[] data) {
        if (data == null || data.length == 0 || key == null || key.length == 0) {
            return data;
        }
        byte[] result = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = (byte)(data[i] ^ key[i % key.length]);
        }
        return result;
    }

    public static Map<String, String> genSM2KeyPair(boolean compressPubKey) throws Exception {
        Map<String, byte[]> sm2KeyMap = SM2.genKeyPair(compressPubKey);
        String publicKeyHex = CommonUtils.byte2hexString(sm2KeyMap.get("publicKey"));
        if (publicKeyHex.startsWith("04") && publicKeyHex.length() >= 96) {
            publicKeyHex = publicKeyHex.substring(2);
        }
        byte[] newKeyBytes = shaded.org.bouncycastle.util.Arrays.concatenate(new byte[1], sm2KeyMap.get("privateKey"));
        BigInteger privateKey = new BigInteger(newKeyBytes);
        String privateKeyHex = privateKey.toString(16);
        HashMap<String, String> keyPair = new HashMap<String, String>();
        keyPair.put("publicHex", publicKeyHex);
        keyPair.put("privateHex", privateKeyHex);
        return keyPair;
    }

    public static String encodeWithPubKey(String data, String publicKeyHex) throws Exception {
        return SMUtil.encodeWithPubKey(data, publicKeyHex, Charset.defaultCharset());
    }

    public static String encodeWithPubKey(String data, String publicKeyHex, int cipherMode) throws Exception {
        return SMUtil.encodeWithPubKey(data, publicKeyHex, Charset.defaultCharset(), cipherMode);
    }

    private static String cipherModeToSM2Mode(int cipherMode) {
        if (cipherMode == 1) {
            return "C1C3C2";
        }
        return "C1C2C3";
    }

    public static String encodeWithPubKey(String data, String publicKeyHex, Charset charset) throws Exception {
        return SMUtil.encodeWithPubKey(data, publicKeyHex, charset, 0);
    }

    public static String encodeWithPubKey(String data, String publicKeyHex, Charset charset, int cipherMode) throws Exception {
        byte[] dataDateBytes = data.getBytes(charset);
        byte[] publicKeyBytes = CommonUtils.hexString2byte(publicKeyHex);
        byte[] resultBytes = SM2.encrypt(dataDateBytes, publicKeyBytes, SMUtil.cipherModeToSM2Mode(cipherMode));
        return Hex.toHexString(resultBytes);
    }

    public static String encodeWithPubKey(String data, String publicKeyHex, int cipherMode, Digest digest) throws Exception {
        return SMUtil.encodeWithPubKey(data, publicKeyHex, cipherMode, digest, Charset.defaultCharset());
    }

    public static String encodeWithPubKey(String data, String publicKeyHex, int cipherMode, Digest digest, Charset charset) throws Exception {
        if (publicKeyHex.length() >= 96) {
            publicKeyHex = "04" + publicKeyHex;
        }
        byte[] dataDateByte = data.getBytes(charset);
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName(ALGORITHM);
        ECDomainParameters domainParameters = SMUtil.instanceECDomainParameters();
        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(CommonUtils.hexString2byte(publicKeyHex));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2EngineExtend sm2Engine = SMUtil.instanceSM2EngineExtend(digest);
        sm2Engine.init(true, cipherMode, new ParametersWithRandom(publicKeyParameters, new SecureRandom()));
        byte[] arrayOfBytes = sm2Engine.processBlock(dataDateByte, 0, dataDateByte.length);
        String cipherText = Hex.toHexString(arrayOfBytes);
        Arrays.fill(arrayOfBytes, (byte)0);
        if (cipherText.indexOf("04") == 0) {
            cipherText = cipherText.substring(2, cipherText.length());
        }
        return cipherText;
    }

    public static String decodeWithPrivKey(String cipherText, String privateKeyHex) throws Exception {
        return SMUtil.decodeWithPrivKey(cipherText, privateKeyHex, Charset.defaultCharset());
    }

    public static String decodeWithPrivKey(String cipherText, String privateKeyHex, int cipherMode) throws Exception {
        return SMUtil.decodeWithPrivKey(cipherText, privateKeyHex, Charset.defaultCharset(), cipherMode);
    }

    public static String decodeWithPrivKey(String cipherText, String privateKeyHex, Charset charset) throws Exception {
        return SMUtil.decodeWithPrivKey(cipherText, privateKeyHex, charset, 0);
    }

    public static String decodeWithPrivKey(String cipherText, String privateKeyHex, Charset charset, int cipherMode) throws Exception {
        byte[] privateKeyBytes = new BigInteger(privateKeyHex, 16).toByteArray();
        byte[] cipherTextBytes = Hex.decode(cipherText);
        byte[] resultBytes = SM2.decrypt(cipherTextBytes, privateKeyBytes, SMUtil.cipherModeToSM2Mode(cipherMode));
        return new String(resultBytes, charset);
    }

    public static String decodeWithPrivKey(String cipherText, String privateKeyHex, int cipherMode, Digest digest) throws Exception {
        return SMUtil.decodeWithPrivKey(cipherText, privateKeyHex, cipherMode, digest, Charset.defaultCharset());
    }

    public static String decodeWithPrivKey(String cipherText, String privateKeyHex, int cipherMode, Digest digest, Charset charset) throws Exception {
        cipherText = "04" + cipherText;
        byte[] cipherDateByte = Hex.decode(cipherText);
        ECDomainParameters domainParameters = SMUtil.instanceECDomainParameters();
        BigInteger privateKeyD = new BigInteger(privateKeyHex, 16);
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2EngineExtend sm2Engine = SMUtil.instanceSM2EngineExtend(digest);
        sm2Engine.init(false, cipherMode, privateKeyParameters);
        byte[] arrayOfBytes = sm2Engine.processBlock(cipherDateByte, 0, cipherDateByte.length);
        String data = new String(arrayOfBytes, charset);
        Arrays.fill(arrayOfBytes, (byte)0);
        return data;
    }

    public static String signWithSM2(String data, String privateKeyHex) throws Exception {
        return SMUtil.signWithSM2(data, privateKeyHex, Charset.defaultCharset());
    }

    public static String signWithSM2(String data, String privateKeyHex, Charset charset) throws Exception {
        BigInteger privateKey = new BigInteger(privateKeyHex, 16);
        byte[] dataBytes = data.getBytes(charset);
        byte[] resultBytes = SM2.sign(dataBytes, privateKey.toByteArray());
        return CommonUtils.byte2hexString(resultBytes);
    }

    public static boolean verifyWithSM2(String data, String publicKeyHex, String signature) {
        return SMUtil.verifyWithSM2(data, publicKeyHex, signature, Charset.defaultCharset());
    }

    public static boolean verifyWithSM2(String data, String publicKeyHex, String signature, Charset charset) {
        byte[] dataDateBytes = data.getBytes(charset);
        byte[] publicKeyBytes = CommonUtils.hexString2byte(publicKeyHex);
        byte[] signDataBytes = CommonUtils.hexString2byte(signature);
        try {
            if (signature.length() > 128) {
                BigInteger[] rs = StandardDSAEncoding.INSTANCE.decode(SMUtil.instanceECDomainParameters().getN(), signDataBytes);
                return SM2.verifySign(dataDateBytes, publicKeyBytes, SMUtil.regSinature(rs));
            }
            return SM2.verifySign(dataDateBytes, publicKeyBytes, signDataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static byte[] regSinature(BigInteger[] rs) {
        byte[] r = rs[0].toByteArray();
        byte[] s = rs[1].toByteArray();
        r = SMUtil.formatRS(r);
        s = SMUtil.formatRS(s);
        return shaded.org.bouncycastle.util.Arrays.concatenate(r, s);
    }

    private static byte[] formatRS(byte[] rs) {
        byte[] result = rs;
        if (result.length > 32) {
            result = shaded.org.bouncycastle.util.Arrays.copyOfRange(result, result.length - 32, result.length);
        } else if (result.length < 32) {
            byte[] temp = new byte[32];
            System.arraycopy(result, 0, temp, 32 - result.length, result.length);
            result = temp;
        }
        return result;
    }

    public static SMS4 instanceSMS4() {
        if (sms4 == null) {
            sms4 = new SMS4();
        }
        return sms4;
    }

    public static com.cib.smtools.security.SM4 instanceSM4() {
        if (sm4 == null) {
            sm4 = new com.cib.smtools.security.SM4();
        }
        return sm4;
    }

    public static SM4Context instanceSM4Context() {
        if (ctx == null) {
            ctx = new SM4Context();
        }
        return ctx;
    }

    public static SM2Engine instanceSM2Engine() {
        SM2Engine sm2Engine = threadSM2Engine.get();
        if (sm2Engine == null) {
            sm2Engine = new SM2Engine();
            threadSM2Engine.set(sm2Engine);
        }
        return sm2Engine;
    }

    public static ECDomainParameters instanceECDomainParameters() {
        if (eCDomainParameters == null) {
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName(ALGORITHM);
            eCDomainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        }
        return eCDomainParameters;
    }

    public static SM2EngineExtend instanceSM2EngineExtend(Digest digest) {
        Map<String, SM2EngineExtend> sm2EngineExendMap = sm2EngineExendMapThread.get();
        if (sm2EngineExendMap == null) {
            sm2EngineExendMap = new HashMap<String, SM2EngineExtend>();
            sm2EngineExendMapThread.set(sm2EngineExendMap);
        }
        SM2EngineExtend sm2EngineExtend = null;
        if (digest == null) {
            sm2EngineExtend = sm2EngineExendMap.get("digest-null");
            if (sm2EngineExtend == null) {
                sm2EngineExtend = new SM2EngineExtend();
                sm2EngineExendMap.put("digest-null", sm2EngineExtend);
            }
        } else {
            String algorithmName = digest.getAlgorithmName();
            sm2EngineExtend = sm2EngineExendMap.get(algorithmName);
            if (sm2EngineExtend == null) {
                sm2EngineExtend = new SM2EngineExtend(digest);
                sm2EngineExendMap.put(algorithmName, sm2EngineExtend);
            }
        }
        return sm2EngineExtend;
    }

    public static void testMethod() throws Exception {
        String encodeStr = "MTlzNDU2Nzg";
        String resultString = SMUtil.sm4EcryptEBC(encodeStr);
        resultString = SMUtil.sm4EcryptEBC(encodeStr, "20141131201411312014113120141131");
        resultString = SMUtil.sm4EcryptCBC(encodeStr);
        resultString = SMUtil.sm4EcryptCBC(encodeStr, "2014113120141131");
        resultString = SMUtil.sm3Ecrypt(encodeStr);
        String text = "this is a test message!";
        String sm3HashMac = SMUtil.sm3EcryptHMAC(text, "1234abcd");
        for (int i = 0; i < 200; ++i) {
            Map<String, String> map = SMUtil.genSM2KeyPair(false);
            String puHex = map.get("publicHex");
            String pvHex = map.get("privateHex");
            String data = "43\u53d1\u96a7\u905390^&*&^$^&)(<LK>ASUjhko9 ,.?><:}[}{]";
            String enPuvalue = SMUtil.encodeWithPubKey(data, puHex);
            String enPuvalue2 = SMUtil.encodeWithPubKey(data, puHex, 0, null);
            System.out.println("SM2\u516c\u94a5\u52a0\u5bc6\uff0c\u52a0\u5bc6\u6570\u636e\u6392\u5217\u6a21\u5f0f\uff0c\u660e\u6587\uff1a" + data + " \u5bc6\u6587\uff1a" + enPuvalue2);
            if (enPuvalue.indexOf("04") == 0 || enPuvalue2.indexOf("04") == 0) {
                System.out.println("\u5b58\u5728\u662f04\u5f00\u5934\u7684\u5bc6\u6587");
            }
            String deValue = SMUtil.decodeWithPrivKey(enPuvalue, pvHex);
            String deValue2 = SMUtil.decodeWithPrivKey(enPuvalue2, pvHex, 0, null);
            System.out.println("SM2\u79c1\u94a5\u89e3\u5bc6\uff0c\u89e3\u5bc6\u660e\u6587\uff1a" + deValue);
            System.out.println("SM2\u79c1\u94a5\u89e3\u5bc6 \u52a0\u5bc6\u6570\u636e\u6392\u5217\u6a21\u5f0f\uff0c\u89e3\u5bc6\u660e\u6587\uff1a\uff1a" + deValue2);
            Blake2bDigest digest = new Blake2bDigest();
            String enPuvalue3 = SMUtil.encodeWithPubKey(data, puHex, 1, digest);
            String deValue3 = SMUtil.decodeWithPrivKey(enPuvalue3, pvHex, 1, digest);
            if (data.equals(deValue) && data.equals(deValue2)) continue;
            throw new RuntimeException("\u89e3\u5bc6\u5931\u8d25");
        }
    }
}

