/*
 * Decompiled with CFR 0.152.
 */
package com.cib.smtools.sm;

import com.cib.smtools.sm.CIBSMTools;
import java.security.Security;
import shaded.org.bouncycastle.crypto.digests.SM3Digest;
import shaded.org.bouncycastle.crypto.macs.HMac;
import shaded.org.bouncycastle.crypto.params.KeyParameter;
import shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.org.bouncycastle.util.encoders.Hex;

public class SM3 {
    public static byte[] hash(byte[] text) throws Exception {
        CIBSMTools.checkStatus();
        if (text == null) {
            return null;
        }
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(text, 0, text.length);
        byte[] hash = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(hash, 0);
        return hash;
    }

    public static byte[] hmac(byte[] text, byte[] key) throws Exception {
        CIBSMTools.checkStatus();
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac hmac = new HMac(digest);
        hmac.init(keyParameter);
        hmac.update(text, 0, text.length);
        byte[] hash = new byte[hmac.getMacSize()];
        hmac.doFinal(hash, 0);
        return hash;
    }

    public static boolean selfCheck() throws Exception {
        try {
            boolean bool;
            boolean bl = bool = SM3.sm3HMACTest(100) && SM3.sm3Test(100);
            if (!bool) {
                throw new Exception("Error code:10003");
            }
        }
        catch (Exception e) {
            throw new Exception("Error code:10003", e);
        }
        return true;
    }

    private static boolean sm3HMACTest(int number) {
        String sm3HMACInput128 = "f015aad616f4d56e0eb1bce68f97df46e3aa805851144498e12290a4e3d118857258f65f87e87f8960ef987b1e89d88ad2196e8b6097dcdd6f8a024488a0337a53e7fdc2c3a073350d2c9f0b363d9ea4c51c8fa0a4fe1645e2cd4710ad7b17427c49a6ec103e59f6bcc76c8c97a288125d5436a49c34a87a2f15a08a29159c47";
        String sm3HMACKey128 = "921d364a853f1913e1bc92caa863ba9f42a023b3cec482a9c62297719343a7ca8568a9cf810ad9783f589921f00b9301f60660d008e1a9c68eb30dd49d68b7c7a5a656301db867b301f3177366e6a19c667ddd8f1e759266ea80b0a18a674d909f914a646bec8c26b2f4bd2213f114d70cb9079080df1a825bba5b33d7d0a1e6";
        String sm3HMACOutput128 = "720A0C905FA1ECCBD98DA3D506AE124A2F84651DFACE0C1475E1ED018E2FC23C";
        String sm3HMACInput64 = "624b3dbfca7647dbe053fe235b102712df80b0b337288767005d03197d607b39e7b6b4614230228e9c8bb967a3ed4cdfe292f3684c14b9120bf9d0cc9b6d8bff";
        String sm3HMACKey64 = "c38e97ec0124864afaa22ed6b97f5a29e7b9ead5a7b1e61b1e05dd754dc55953b3bcc98e9202dae1d33125e0406b1790a814b8660dc465cf81f0da0218a20176";
        String sm3HMACOutput64 = "E849E65CDBD545C16927A406F3D039622798E08190BED7F24C4D2DFC7D5D58A3";
        String sm3HMACInput32 = "a883f63018089b68877d7bafc3ee1188b87780c269cc54d1ac79ff3a29897d1f";
        String sm3HMACKey32 = "085c51137fc98d0699d97aaa839a66f0b43fae7d930ff0a034cfc371543d99cd";
        String sm3HMACOutput32 = "CCDF165BB326F9CF5976DB8829C8130526B309EAEF54B9E9908EF00517B7DBF0";
        boolean bool = true;
        try {
            for (int i = 0; i < number; ++i) {
                String resStr = SM3.smHashCode(SM3.hmac(Hex.decode(sm3HMACInput128), Hex.decode(sm3HMACKey128)));
                if (!sm3HMACOutput128.equals(resStr)) {
                    return false;
                }
                resStr = SM3.smHashCode(SM3.hmac(Hex.decode(sm3HMACInput64), Hex.decode(sm3HMACKey64)));
                if (!sm3HMACOutput64.equals(resStr)) {
                    return false;
                }
                resStr = SM3.smHashCode(SM3.hmac(Hex.decode(sm3HMACInput32), Hex.decode(sm3HMACKey32)));
                if (sm3HMACOutput32.equals(resStr)) continue;
                return false;
            }
        }
        catch (Exception e) {
            bool = false;
            e.printStackTrace();
        }
        return bool;
    }

    private static boolean sm3Test(int number) throws Exception {
        String strsm3Ecypt16 = "16C221585B2836829ED8415BADFFE5ADE8C699932628B15ECF8628A34148B4B1";
        String strsm3Ecypt32 = "93BA10F405AD866E99C370A6FC3067A0946E8DF6D2664D7D489C6FD65AF8F1C8";
        String strsm3Ecypt256 = "D36A7C97EEC1A3F534D0E1DC32F32394CD058240F30D4C458E5AD1FCC82D4576";
        String strsm3Ecypt1024 = "DCDEF7C5ED8669B2E3AE80CAA8CE236B985AC7D168B476A64035C490C80AE329";
        String strsm3Ecypt4096 = "36EFA69B0FB2254370BB13349EB9E6556EB2346EDD56C39FB1D32195F5939676";
        boolean sm3EcrResult = true;
        for (int i = 0; i < number; ++i) {
            String sm3Ecrypt4096;
            String sm3Ecrypt1024;
            String sm3Ecrypt256;
            String sm3Ecrypt32;
            String sm3Ecrypt16 = SM3.smHashCode(SM3.hash(SM3.getSm3EcryptString(1)));
            if (!strsm3Ecypt16.equals(sm3Ecrypt16)) {
                sm3EcrResult = false;
            }
            if (!strsm3Ecypt32.equals(sm3Ecrypt32 = SM3.smHashCode(SM3.hash(SM3.getSm3EcryptString(2))))) {
                sm3EcrResult = false;
            }
            if (!strsm3Ecypt256.equals(sm3Ecrypt256 = SM3.smHashCode(SM3.hash(SM3.getSm3EcryptString(16))))) {
                sm3EcrResult = false;
            }
            if (!strsm3Ecypt1024.equals(sm3Ecrypt1024 = SM3.smHashCode(SM3.hash(SM3.getSm3EcryptString(64))))) {
                sm3EcrResult = false;
            }
            if (strsm3Ecypt4096.equals(sm3Ecrypt4096 = SM3.smHashCode(SM3.hash(SM3.getSm3EcryptString(256))))) continue;
            sm3EcrResult = false;
        }
        return sm3EcrResult;
    }

    private static byte[] getSm3EcryptString(int number) {
        String sm3String = "c194e872b807734ca808f7280c14700e";
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            strBuf.append(sm3String);
        }
        byte[] bytes = Hex.decode(strBuf.toString());
        return bytes;
    }

    private static String smHashCode(byte[] strValue) {
        return Hex.toHexString(strValue).toUpperCase();
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

