/*
 * Decompiled with CFR 0.152.
 */
package com.cib.smtools.security;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import shaded.org.bouncycastle.crypto.digests.SM3Digest;

public class SM3Helper {
    private static final char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String ivHexStr = "7380166f 4914b2b9 172442d7 da8a0600 a96f30bc 163138aa e38dee4d b0fb0e4e";
    private static final BigInteger IV = new BigInteger("7380166f 4914b2b9 172442d7 da8a0600 a96f30bc 163138aa e38dee4d b0fb0e4e".replaceAll(" ", ""), 16);
    private static final Integer Tj15 = Integer.valueOf("79cc4519", 16);
    private static final Integer Tj63 = Integer.valueOf("7a879d8a", 16);
    private static final byte[] FirstPadding = new byte[]{-128};
    private static final byte[] ZeroPadding = new byte[]{0};

    public static byte[] hash(byte[] data) {
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(data, 0, data.length);
        byte[] hash = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(hash, 0);
        return hash;
    }

    public static int T(int j) throws Exception {
        if (j >= 0 && j <= 15) {
            return Tj15;
        }
        if (j >= 16 && j <= 63) {
            return Tj63;
        }
        throw new Exception();
    }

    public static Integer FF(Integer x, Integer y, Integer z, int j) throws Exception {
        if (j >= 0 && j <= 15) {
            return x ^ y ^ z;
        }
        if (j >= 16 && j <= 63) {
            return x & y | x & z | y & z;
        }
        throw new Exception();
    }

    public static Integer GG(Integer x, Integer y, Integer z, int j) throws Exception {
        if (j >= 0 && j <= 15) {
            return x ^ y ^ z;
        }
        if (j >= 16 && j <= 63) {
            return x & y | ~x.intValue() & z;
        }
        throw new Exception();
    }

    public static Integer P0(Integer x) throws Exception {
        return x ^ Integer.rotateLeft(x, 9) ^ Integer.rotateLeft(x, 17);
    }

    public static Integer P1(Integer x) throws Exception {
        return x ^ Integer.rotateLeft(x, 15) ^ Integer.rotateLeft(x, 23);
    }

    public static byte[] padding(byte[] source) throws Exception {
        if ((long)source.length >= 0x2000000000000000L) {
            throw new Exception();
        }
        long l = (long)source.length * 8L;
        long k = 448L - (l + 1L) % 512L;
        if (k < 0L) {
            k += 512L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(source);
        baos.write(FirstPadding);
        for (long i = k - 7L; i > 0L; i -= 8L) {
            baos.write(ZeroPadding);
        }
        baos.write(SM3Helper.long2bytes(l));
        return baos.toByteArray();
    }

    public static byte[] long2bytes(long l) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(l >>> (7 - i) * 8);
        }
        return bytes;
    }

    public static byte[] hashBackUp(byte[] source) throws Exception {
        byte[] m1 = SM3Helper.padding(source);
        int n = m1.length / 64;
        byte[] b = null;
        byte[] vi = IV.toByteArray();
        byte[] vi1 = null;
        for (int i = 0; i < n; ++i) {
            b = Arrays.copyOfRange(m1, i * 64, (i + 1) * 64);
            vi1 = SM3Helper.CF(vi, b);
            vi = vi1;
        }
        return vi1;
    }

    public static byte[] CF(byte[] vi, byte[] bi) throws Exception {
        int j;
        int a = SM3Helper.toInteger(vi, 0);
        int b = SM3Helper.toInteger(vi, 1);
        int c = SM3Helper.toInteger(vi, 2);
        int d = SM3Helper.toInteger(vi, 3);
        int e = SM3Helper.toInteger(vi, 4);
        int f = SM3Helper.toInteger(vi, 5);
        int g = SM3Helper.toInteger(vi, 6);
        int h = SM3Helper.toInteger(vi, 7);
        int[] w = new int[68];
        int[] w1 = new int[64];
        for (int i = 0; i < 16; ++i) {
            w[i] = SM3Helper.toInteger(bi, i);
        }
        for (j = 16; j < 68; ++j) {
            w[j] = SM3Helper.P1(w[j - 16] ^ w[j - 9] ^ Integer.rotateLeft(w[j - 3], 15)) ^ Integer.rotateLeft(w[j - 13], 7) ^ w[j - 6];
        }
        for (j = 0; j < 64; ++j) {
            w1[j] = w[j] ^ w[j + 4];
        }
        for (int j2 = 0; j2 < 64; ++j2) {
            int ss1 = Integer.rotateLeft(Integer.rotateLeft(a, 12) + e + Integer.rotateLeft(SM3Helper.T(j2), j2), 7);
            int ss2 = ss1 ^ Integer.rotateLeft(a, 12);
            int tt1 = SM3Helper.FF(a, b, c, j2) + d + ss2 + w1[j2];
            int tt2 = SM3Helper.GG(e, f, g, j2) + h + ss1 + w[j2];
            d = c;
            c = Integer.rotateLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = Integer.rotateLeft(f, 19);
            f = e;
            e = SM3Helper.P0(tt2);
        }
        byte[] v = SM3Helper.toByteArray(a, b, c, d, e, f, g, h);
        for (int i = 0; i < v.length; ++i) {
            v[i] = (byte)(v[i] ^ vi[i]);
        }
        return v;
    }

    public static int toInteger(byte[] source, int index) {
        StringBuilder valueStr = new StringBuilder("");
        for (int i = 0; i < 4; ++i) {
            valueStr.append(chars[(byte)((source[index * 4 + i] & 0xF0) >> 4)]);
            valueStr.append(chars[(byte)(source[index * 4 + i] & 0xF)]);
        }
        return Long.valueOf(valueStr.toString(), 16).intValue();
    }

    public static byte[] toByteArray(int a, int b, int c, int d, int e, int f, int g, int h) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32);
        baos.write(SM3Helper.toByteArray(a));
        baos.write(SM3Helper.toByteArray(b));
        baos.write(SM3Helper.toByteArray(c));
        baos.write(SM3Helper.toByteArray(d));
        baos.write(SM3Helper.toByteArray(e));
        baos.write(SM3Helper.toByteArray(f));
        baos.write(SM3Helper.toByteArray(g));
        baos.write(SM3Helper.toByteArray(h));
        return baos.toByteArray();
    }

    public static byte[] toByteArray(int i) {
        byte[] byteArray = new byte[]{(byte)(i >>> 24), (byte)((i & 0xFFFFFF) >>> 16), (byte)((i & 0xFFFF) >>> 8), (byte)(i & 0xFF)};
        return byteArray;
    }
}

