/*
 * Decompiled with CFR 0.152.
 */
package net.synedra.validatorfx;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import net.synedra.validatorfx.Decoration;

public class StyleClassDecoration
implements Decoration {
    private final Set<String> styleClasses;

    public StyleClassDecoration(String ... styleClasses) {
        if (styleClasses == null || styleClasses.length == 0) {
            throw new IllegalArgumentException("At least one style class is required");
        }
        this.styleClasses = new HashSet<String>(Arrays.asList(styleClasses));
    }

    @Override
    public void add(Node targetNode) {
        ObservableList styleClassList = targetNode.getStyleClass();
        HashSet<String> toAdd = new HashSet<String>(this.styleClasses);
        toAdd.removeAll((Collection<?>)styleClassList);
        styleClassList.addAll(toAdd);
    }

    @Override
    public void remove(Node targetNode) {
        targetNode.getStyleClass().removeAll(this.styleClasses);
    }
}

