/*
 * Decompiled with CFR 0.152.
 */
package net.synedra.validatorfx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import net.synedra.validatorfx.Decoration;
import net.synedra.validatorfx.DefaultDecoration;
import net.synedra.validatorfx.ValidationMessage;
import net.synedra.validatorfx.ValidationResult;

public class Check {
    private Map<String, ObservableValue<? extends Object>> dependencies = new HashMap<String, ObservableValue<? extends Object>>(1);
    private Consumer<Context> checkMethod;
    private ReadOnlyObjectWrapper<ValidationResult> validationResultProperty = new ReadOnlyObjectWrapper();
    private ValidationResult nextValidationResult = new ValidationResult();
    private List<Node> targets = new ArrayList<Node>(1);
    private List<Decoration> decorations = new ArrayList<Decoration>();
    private Function<ValidationMessage, Decoration> decorationFactory;
    private ChangeListener<? super Object> dependencyListener;

    public Check() {
        this.validationResultProperty.set((Object)new ValidationResult());
        this.decorationFactory = DefaultDecoration.getFactory();
        this.dependencyListener = (obs, oldv, newv) -> this.recheck();
    }

    public Check withMethod(Consumer<Context> checkMethod) {
        this.checkMethod = checkMethod;
        return this;
    }

    public Check dependsOn(String key, ObservableValue<? extends Object> dependency) {
        this.dependencies.put(key, dependency);
        return this;
    }

    public Check decorates(Node target) {
        this.targets.add(target);
        return this;
    }

    public Check decoratingWith(Function<ValidationMessage, Decoration> decorationFactory) {
        this.decorationFactory = decorationFactory;
        return this;
    }

    public Check immediate() {
        for (ObservableValue<? extends Object> dependency : this.dependencies.values()) {
            dependency.addListener(this.dependencyListener);
        }
        Platform.runLater(this::recheck);
        return this;
    }

    public void recheck() {
        this.nextValidationResult = new ValidationResult();
        this.checkMethod.accept(new Context());
        for (Node target : this.targets) {
            for (Decoration decoration : this.decorations) {
                decoration.remove(target);
            }
        }
        this.decorations.clear();
        for (Node target : this.targets) {
            for (ValidationMessage validationMessage : this.nextValidationResult.getMessages()) {
                Decoration decoration = this.decorationFactory.apply(validationMessage);
                this.decorations.add(decoration);
                decoration.add(target);
            }
        }
        if (!this.nextValidationResult.getMessages().equals(this.getValidationResult().getMessages())) {
            this.validationResultProperty.set((Object)this.nextValidationResult);
        }
    }

    public ValidationResult getValidationResult() {
        return (ValidationResult)this.validationResultProperty.get();
    }

    public ReadOnlyObjectProperty<ValidationResult> validationResultProperty() {
        return this.validationResultProperty.getReadOnlyProperty();
    }

    public class Context {
        private Context() {
        }

        public <T> T get(String key) {
            return (T)Check.this.dependencies.get(key).getValue();
        }

        public Iterable<String> keys() {
            return Check.this.dependencies.keySet();
        }

        public void warn(String message) {
            Check.this.nextValidationResult.addWarning(message);
        }

        public void error(String message) {
            Check.this.nextValidationResult.addError(message);
        }
    }
}

