/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa.output;

import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.rootdev.javardfa.StatementSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFXMLSink
implements StatementSink {
    static final Logger log = LoggerFactory.getLogger(RDFXMLSink.class);
    static final String RDFNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private final XMLStreamWriter out;
    private final String[] comments;

    public RDFXMLSink(OutputStream os, String ... comments) {
        this.comments = comments;
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        try {
            this.out = factory.createXMLStreamWriter(os, "utf-8");
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Couldn't create writer", ex);
        }
    }

    @Override
    public void start() {
        try {
            this.out.writeStartDocument("utf-8", "1.0");
            if (this.comments.length != 0) {
                this.out.writeCharacters("\n");
                StringBuilder sb = new StringBuilder("\n");
                for (String line : this.comments) {
                    sb.append(line);
                    sb.append("\n");
                }
                this.out.writeComment(sb.toString());
            }
            this.out.writeCharacters("\n");
            this.out.writeStartElement(RDFNS, "RDF");
            this.out.writeNamespace("rdf", RDFNS);
            this.out.writeCharacters("\n");
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Problem starting document", ex);
        }
    }

    @Override
    public void end() {
        try {
            this.out.writeEndDocument();
            this.out.flush();
            this.out.close();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Problem ending document", ex);
        }
    }

    @Override
    public void addObject(String subject, String predicate, String object) {
        try {
            this.out.writeStartElement(RDFNS, "Description");
            this.writeSubject(subject);
            this.out.writeCharacters("\n\t");
            this.writePredicate(predicate, true);
            this.writeObject(object);
            this.out.writeCharacters("\n");
            this.out.writeEndElement();
            this.out.writeCharacters("\n");
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Problem writing statement", ex);
        }
    }

    @Override
    public void addLiteral(String subject, String predicate, String lex, String lang, String datatype) {
        try {
            this.out.writeStartElement(RDFNS, "Description");
            this.writeSubject(subject);
            this.out.writeCharacters("\n\t");
            this.writePredicate(predicate, false);
            this.writeLiteral(lex, lang, datatype);
            this.out.writeEndElement();
            this.out.writeCharacters("\n");
            this.out.writeEndElement();
            this.out.writeCharacters("\n");
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Problem writing statement", ex);
        }
    }

    @Override
    public void addPrefix(String prefix, String uri) {
    }

    private void writeSubject(String subject) throws XMLStreamException {
        if (this.blank(subject)) {
            this.out.writeAttribute(RDFNS, "nodeID", this.id(subject));
        } else {
            this.out.writeAttribute(RDFNS, "about", subject);
        }
    }

    private void writePredicate(String predicate, boolean closed) throws XMLStreamException {
        String[] nsln = this.split(predicate);
        if (closed) {
            this.out.writeEmptyElement("ns", nsln[1], nsln[0]);
        } else {
            this.out.writeStartElement("ns", nsln[1], nsln[0]);
        }
        this.out.writeNamespace("ns", nsln[0]);
    }

    private void writeObject(String object) throws XMLStreamException {
        if (this.blank(object)) {
            this.out.writeAttribute(RDFNS, "nodeID", this.id(object));
        } else {
            this.out.writeAttribute(RDFNS, "resource", object);
        }
    }

    private void writeLiteral(String lex, String lang, String datatype) throws XMLStreamException {
        if (lang != null) {
            this.out.writeAttribute("xml:lang", lang);
        } else if (datatype != null) {
            this.out.writeAttribute(RDFNS, "datatype", datatype);
        }
        this.out.writeCharacters(lex);
    }

    private boolean blank(String subject) {
        return subject.startsWith("_:");
    }

    private String id(String subject) {
        return subject.substring(2);
    }

    protected String[] split(String predicate) {
        String[] toReturn = new String[2];
        int lastStartChar = -1;
        for (int i = predicate.length() - 1; i > 0 && this.isNameChar(predicate.codePointAt(i)); --i) {
            if (!this.isNameStartChar(predicate.codePointAt(i))) continue;
            lastStartChar = i;
        }
        if (lastStartChar == -1) {
            throw new RuntimeException("Unsplitable predicate " + predicate);
        }
        toReturn[0] = predicate.substring(0, lastStartChar);
        toReturn[1] = predicate.substring(lastStartChar);
        return toReturn;
    }

    private boolean isNameChar(int cp) {
        return this.isNameStartChar(cp) || cp == 46 || cp == 45 || cp >= 48 && cp <= 57;
    }

    private boolean isNameStartChar(int cp) {
        return cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || cp == 58 || cp == 95;
    }

    @Override
    public void setBase(String base) {
    }
}

