/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import org.jooq.Converter;
import org.jooq.DSLContext;
import org.jooq.TableLike;
import zipkin2.storage.mysql.v1.Schema;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinAnnotations;

final class SelectAutocompleteValues
implements Function<DSLContext, List<String>> {
    final Schema schema;
    final String autocompleteKey;
    static final Converter<byte[], String> STRING_CONVERTER = new Converter<byte[], String>(){

        public String from(byte[] bytes) {
            return new String(bytes, StandardCharsets.UTF_8);
        }

        public byte[] to(String input) {
            return input.getBytes(StandardCharsets.UTF_8);
        }

        public Class<byte[]> fromType() {
            return byte[].class;
        }

        public Class<String> toType() {
            return String.class;
        }
    };

    SelectAutocompleteValues(Schema schema, String autocompleteKey) {
        this.schema = schema;
        this.autocompleteKey = autocompleteKey;
    }

    @Override
    public List<String> apply(DSLContext context) {
        return context.selectDistinct(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_VALUE).from((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).where(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TYPE.eq((Object)6).and(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY.eq((Object)this.autocompleteKey))).fetch(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_VALUE, STRING_CONVERTER);
    }
}

