/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.data.util;

import io.weaviate.client.base.util.DbVersionSupport;
import io.weaviate.client.base.util.TriConsumer;
import io.weaviate.client.base.util.UrlEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ReferencesPath {
    private final DbVersionSupport support;

    public ReferencesPath(DbVersionSupport support) {
        this.support = support;
    }

    public String buildCreate(Params params) {
        return this.commonBuild(params);
    }

    public String buildDelete(Params params) {
        return this.commonBuild(params);
    }

    public String buildReplace(Params params) {
        return this.commonBuild(params);
    }

    private String commonBuild(Params params) {
        return this.build(params, this::addPathClassNameWithDeprecatedNotSupportedCheck, this::addPathId, this::addPathReferences, this::addPathProperty, this::addQueryConsistencyLevel, this::addQueryTenant);
    }

    @SafeVarargs
    private final String build(Params params, TriConsumer<Params, List<String>, List<String>> ... appenders) {
        Objects.requireNonNull(params);
        ArrayList<String> pathParams = new ArrayList<String>();
        ArrayList queryParams = new ArrayList();
        pathParams.add("/objects");
        Arrays.stream(appenders).forEach(consumer -> consumer.accept(params, pathParams, queryParams));
        String path = String.join((CharSequence)"/", pathParams);
        if (!queryParams.isEmpty()) {
            return path + "?" + String.join((CharSequence)"&", queryParams);
        }
        return path;
    }

    private void addPathClassNameWithDeprecatedNotSupportedCheck(Params params, List<String> pathParams, List<String> queryParams) {
        if (this.support.supportsClassNameNamespacedEndpoints()) {
            if (StringUtils.isNotBlank((CharSequence)params.className)) {
                pathParams.add(UrlEncoder.encodePathParam(params.className));
            } else {
                this.support.warnDeprecatedNonClassNameNamespacedEndpointsForObjects();
            }
        } else if (StringUtils.isNotBlank((CharSequence)params.className)) {
            this.support.warnNotSupportedClassNamespacedEndpointsForObjects();
        }
    }

    private void addPathId(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.id)) {
            pathParams.add(UrlEncoder.encodePathParam(params.id));
        }
    }

    private void addPathReferences(Params params, List<String> pathParams, List<String> queryParams) {
        pathParams.add("references");
    }

    private void addPathProperty(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.property)) {
            pathParams.add(UrlEncoder.encodePathParam(params.property));
        }
    }

    private void addQueryConsistencyLevel(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.consistencyLevel)) {
            queryParams.add(UrlEncoder.encodeQueryParam("consistency_level", params.consistencyLevel));
        }
    }

    private void addQueryTenant(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.tenant)) {
            queryParams.add(UrlEncoder.encodeQueryParam("tenant", params.tenant));
        }
    }

    public static class Params {
        private final String id;
        private final String className;
        private final String consistencyLevel;
        private final String tenant;
        private final String property;

        @Generated
        Params(String id, String className, String consistencyLevel, String tenant, String property) {
            this.id = id;
            this.className = className;
            this.consistencyLevel = consistencyLevel;
            this.tenant = tenant;
            this.property = property;
        }

        @Generated
        public static ParamsBuilder builder() {
            return new ParamsBuilder();
        }

        @Generated
        public String toString() {
            return "ReferencesPath.Params(id=" + this.id + ", className=" + this.className + ", consistencyLevel=" + this.consistencyLevel + ", tenant=" + this.tenant + ", property=" + this.property + ")";
        }

        @Generated
        public static class ParamsBuilder {
            @Generated
            private String id;
            @Generated
            private String className;
            @Generated
            private String consistencyLevel;
            @Generated
            private String tenant;
            @Generated
            private String property;

            @Generated
            ParamsBuilder() {
            }

            @Generated
            public ParamsBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public ParamsBuilder className(String className) {
                this.className = className;
                return this;
            }

            @Generated
            public ParamsBuilder consistencyLevel(String consistencyLevel) {
                this.consistencyLevel = consistencyLevel;
                return this;
            }

            @Generated
            public ParamsBuilder tenant(String tenant) {
                this.tenant = tenant;
                return this;
            }

            @Generated
            public ParamsBuilder property(String property) {
                this.property = property;
                return this;
            }

            @Generated
            public Params build() {
                return new Params(this.id, this.className, this.consistencyLevel, this.tenant, this.property);
            }

            @Generated
            public String toString() {
                return "ReferencesPath.Params.ParamsBuilder(id=" + this.id + ", className=" + this.className + ", consistencyLevel=" + this.consistencyLevel + ", tenant=" + this.tenant + ", property=" + this.property + ")";
            }
        }
    }
}

