/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import io.spring.initializr.generator.buildsystem.gradle.GradlePlugin;
import io.spring.initializr.generator.buildsystem.gradle.StandardGradlePlugin;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class GradlePluginContainer {
    private final Map<String, GradlePlugin> plugins = new LinkedHashMap<String, GradlePlugin>();

    public boolean isEmpty() {
        return this.plugins.isEmpty();
    }

    public boolean has(String id) {
        return this.plugins.containsKey(id);
    }

    public Stream<GradlePlugin> values() {
        return this.plugins.values().stream();
    }

    public void add(String id) {
        this.addPlugin(id, StandardGradlePlugin::new);
    }

    public void add(String id, Consumer<StandardGradlePlugin> plugin) {
        GradlePlugin gradlePlugin = this.addPlugin(id, StandardGradlePlugin::new);
        if (gradlePlugin instanceof StandardGradlePlugin) {
            plugin.accept((StandardGradlePlugin)gradlePlugin);
        }
    }

    public void apply(String id) {
        this.addPlugin(id, pluginId -> new GradlePlugin((String)pluginId, true));
    }

    private GradlePlugin addPlugin(String id, Function<String, GradlePlugin> pluginId) {
        return this.plugins.computeIfAbsent(id, pluginId);
    }

    public boolean remove(String id) {
        return this.plugins.remove(id) != null;
    }
}

