/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import io.spring.initializr.generator.buildsystem.gradle.GradleConfiguration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class GradleConfigurationContainer {
    private final Set<String> configurations = new LinkedHashSet<String>();
    private final Map<String, GradleConfiguration.Builder> configurationCustomizations = new LinkedHashMap<String, GradleConfiguration.Builder>();

    public boolean isEmpty() {
        return this.configurations.isEmpty() && this.configurationCustomizations.isEmpty();
    }

    public boolean has(String name) {
        return this.configurations.contains(name) || this.configurationCustomizations.containsKey(name);
    }

    public Stream<String> names() {
        return this.configurations.stream();
    }

    public Stream<GradleConfiguration> customizations() {
        return this.configurationCustomizations.values().stream().map(GradleConfiguration.Builder::build);
    }

    public void add(String name) {
        this.configurations.add(name);
    }

    public void customize(String name, Consumer<GradleConfiguration.Builder> configuration) {
        GradleConfiguration.Builder builder = this.configurationCustomizations.computeIfAbsent(name, GradleConfiguration.Builder::new);
        configuration.accept(builder);
    }

    public boolean remove(String name) {
        if (this.configurations.remove(name)) {
            return true;
        }
        return this.configurationCustomizations.remove(name) != null;
    }
}

