/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build.maven;

import io.spring.initializr.generator.buildsystem.BillOfMaterials;
import io.spring.initializr.generator.buildsystem.maven.MavenBuild;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.version.VersionProperty;
import io.spring.initializr.metadata.InitializrConfiguration;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.support.MetadataBuildItemMapper;

public class DefaultMavenBuildCustomizer
implements BuildCustomizer<MavenBuild> {
    private final ProjectDescription description;
    private final InitializrMetadata metadata;

    public DefaultMavenBuildCustomizer(ProjectDescription description, InitializrMetadata metadata) {
        this.description = description;
        this.metadata = metadata;
    }

    @Override
    public void customize(MavenBuild build) {
        String versionProperty;
        BillOfMaterials springBootBom;
        build.settings().name(this.description.getName()).description(this.description.getDescription());
        build.properties().property("java.version", this.description.getLanguage().jvmVersion());
        build.plugins().add("org.springframework.boot", "spring-boot-maven-plugin");
        InitializrConfiguration.Env.Maven maven = this.metadata.getConfiguration().getEnv().getMaven();
        String springBootVersion = this.description.getPlatformVersion().toString();
        InitializrConfiguration.Env.Maven.ParentPom parentPom = maven.resolveParentPom(springBootVersion);
        if (parentPom.isIncludeSpringBootBom() && !this.hasBom(build, springBootBom = MetadataBuildItemMapper.toBom((io.spring.initializr.metadata.BillOfMaterials)this.metadata.createSpringBootBom(springBootVersion, versionProperty = "spring-boot.version")))) {
            build.properties().version(VersionProperty.of((String)versionProperty, (boolean)true), springBootVersion);
            build.boms().add((Object)"spring-boot", (Object)springBootBom);
        }
        if (!maven.isSpringBootStarterParent(parentPom)) {
            build.properties().property("project.build.sourceEncoding", "UTF-8").property("project.reporting.outputEncoding", "UTF-8");
        }
        build.settings().parent(parentPom.getGroupId(), parentPom.getArtifactId(), parentPom.getVersion(), parentPom.getRelativePath());
    }

    private boolean hasBom(MavenBuild build, BillOfMaterials bom) {
        return build.boms().items().anyMatch(candidate -> candidate.getGroupId().equals(bom.getGroupId()) && candidate.getArtifactId().equals(bom.getArtifactId()));
    }
}

