/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.CompositeConverter;
import io.netty.util.internal.PlatformDependent;
import io.seata.server.logging.logback.ansi.AnsiColor;
import io.seata.server.logging.logback.ansi.AnsiElement;
import io.seata.server.logging.logback.ansi.AnsiOutput;
import io.seata.server.logging.logback.ansi.AnsiStyle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ColorConverter
extends CompositeConverter<ILoggingEvent> {
    private static final Map<String, AnsiElement> ELEMENTS;
    private static final String DISABLE_PROPERTY_NAME = "logback.color.disable-for-bat";
    private static final Map<Integer, AnsiElement> LEVELS;
    private final boolean disable = PlatformDependent.isWindows() && Boolean.parseBoolean(System.getProperty("logback.color.disable-for-bat"));

    protected String transform(ILoggingEvent event, String in) {
        if (this.disable) {
            return in;
        }
        AnsiElement element = ELEMENTS.get(this.getFirstOption());
        if (element == null) {
            element = LEVELS.get(event.getLevel().toInteger());
            element = element != null ? element : AnsiColor.GREEN;
        }
        return this.toAnsiString(in, element);
    }

    protected String toAnsiString(String in, AnsiElement element) {
        return AnsiOutput.toString(element, in);
    }

    static {
        HashMap<String, Enum> ansiElements = new HashMap<String, Enum>();
        ansiElements.put("faint", AnsiStyle.FAINT);
        ansiElements.put("red", AnsiColor.RED);
        ansiElements.put("green", AnsiColor.GREEN);
        ansiElements.put("yellow", AnsiColor.YELLOW);
        ansiElements.put("blue", AnsiColor.BLUE);
        ansiElements.put("magenta", AnsiColor.MAGENTA);
        ansiElements.put("cyan", AnsiColor.CYAN);
        ELEMENTS = Collections.unmodifiableMap(ansiElements);
        HashMap<Integer, AnsiColor> ansiLevels = new HashMap<Integer, AnsiColor>();
        ansiLevels.put(Level.ERROR_INTEGER, AnsiColor.RED);
        ansiLevels.put(Level.WARN_INTEGER, AnsiColor.YELLOW);
        LEVELS = Collections.unmodifiableMap(ansiLevels);
    }
}

