/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db.sql.lock;

import io.seata.common.exception.NotSupportYetException;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.store.db.sql.lock.LockStoreSql;

public class AbstractLockStoreSql
implements LockStoreSql {
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    protected static final String LOCK_TABLE_PLACE_HOLD = " #lock_table# ";
    protected static final String IN_PARAMS_PLACE_HOLD = " #in_params# ";
    protected static final String ALL_COLUMNS = "xid, transaction_id, branch_id, resource_id, table_name, pk, row_key, gmt_create, gmt_modified";
    private static final String DELETE_LOCK_SQL = "delete from  #lock_table#  where row_key = ? and xid = ?";
    private static final String BATCH_DELETE_LOCK_SQL = "delete from  #lock_table#  where xid = ? and row_key in ( #in_params# ) ";
    private static final String BATCH_DELETE_LOCK_BY_BRANCH_SQL = "delete from  #lock_table#  where xid = ? and branch_id = ? ";
    private static final String BATCH_DELETE_LOCK_BY_BRANCHS_SQL = "delete from  #lock_table#  where xid = ? and branch_id in ( #in_params# ) ";
    private static final String QUERY_LOCK_SQL = "select xid, transaction_id, branch_id, resource_id, table_name, pk, row_key, gmt_create, gmt_modified from  #lock_table#  where row_key = ? ";
    private static final String CHECK_LOCK_SQL = "select xid, transaction_id, branch_id, resource_id, table_name, pk, row_key, gmt_create, gmt_modified from  #lock_table#  where row_key in ( #in_params# )";

    @Override
    public String getInsertLockSQL(String lockTable) {
        throw new NotSupportYetException("unknown dbType:" + CONFIG.getConfig("store.db.dbType"));
    }

    @Override
    public String getDeleteLockSql(String lockTable) {
        return DELETE_LOCK_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable);
    }

    @Override
    public String getBatchDeleteLockSql(String lockTable, String paramPlaceHold) {
        return BATCH_DELETE_LOCK_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable).replace(IN_PARAMS_PLACE_HOLD, paramPlaceHold);
    }

    @Override
    public String getBatchDeleteLockSqlByBranch(String lockTable) {
        return BATCH_DELETE_LOCK_BY_BRANCH_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable);
    }

    @Override
    public String getBatchDeleteLockSqlByBranchs(String lockTable, String paramPlaceHold) {
        return BATCH_DELETE_LOCK_BY_BRANCHS_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable).replace(IN_PARAMS_PLACE_HOLD, paramPlaceHold);
    }

    @Override
    public String getQueryLockSql(String lockTable) {
        return QUERY_LOCK_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable);
    }

    @Override
    public String getCheckLockableSql(String lockTable, String paramPlaceHold) {
        return CHECK_LOCK_SQL.replace(LOCK_TABLE_PLACE_HOLD, lockTable).replace(IN_PARAMS_PLACE_HOLD, paramPlaceHold);
    }
}

