/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol.transaction;

import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.core.protocol.MergedMessage;
import io.seata.core.protocol.transaction.AbstractTransactionRequestToTC;
import io.seata.core.protocol.transaction.AbstractTransactionResponse;
import io.seata.core.rpc.RpcContext;
import java.nio.ByteBuffer;

public class BranchReportRequest
extends AbstractTransactionRequestToTC
implements MergedMessage {
    private String xid;
    private long branchId;
    private String resourceId;
    private BranchStatus status;
    private String applicationData;
    private BranchType branchType = BranchType.AT;

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public long getBranchId() {
        return this.branchId;
    }

    public void setBranchId(long branchId) {
        this.branchId = branchId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public void setBranchType(BranchType branchType) {
        this.branchType = branchType;
    }

    public BranchStatus getStatus() {
        return this.status;
    }

    public void setStatus(BranchStatus status) {
        this.status = status;
    }

    public String getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(String applicationData) {
        this.applicationData = applicationData;
    }

    @Override
    public short getTypeCode() {
        return 13;
    }

    @Override
    public byte[] encode() {
        byte[] bs;
        byte[] applicationDataBytes = null;
        if (this.applicationData != null && (applicationDataBytes = this.applicationData.getBytes(UTF8)).length > 512) {
            this.byteBuffer = ByteBuffer.allocate(applicationDataBytes.length + 1024);
        }
        if (this.xid != null) {
            bs = this.xid.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        this.byteBuffer.putLong(this.branchId);
        this.byteBuffer.put((byte)this.status.getCode());
        if (this.resourceId != null) {
            bs = this.resourceId.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        if (this.applicationData != null) {
            this.byteBuffer.putInt(applicationDataBytes.length);
            if (applicationDataBytes.length > 0) {
                this.byteBuffer.put(applicationDataBytes);
            }
        } else {
            this.byteBuffer.putInt(0);
        }
        this.byteBuffer.put((byte)this.branchType.ordinal());
        this.byteBuffer.flip();
        byte[] content = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(content);
        return content;
    }

    @Override
    public void decode(ByteBuffer byteBuffer) {
        int iLen;
        short xidLen = byteBuffer.getShort();
        if (xidLen > 0) {
            byte[] bs = new byte[xidLen];
            byteBuffer.get(bs);
            this.setXid(new String(bs, UTF8));
        }
        this.branchId = byteBuffer.getLong();
        this.status = BranchStatus.get(byteBuffer.get());
        short len = byteBuffer.getShort();
        if (len > 0) {
            byte[] bs = new byte[len];
            byteBuffer.get(bs);
            this.resourceId = new String(bs, UTF8);
        }
        if ((iLen = byteBuffer.getInt()) > 0) {
            byte[] bs = new byte[iLen];
            byteBuffer.get(bs);
            this.applicationData = new String(bs, UTF8);
        }
        this.branchType = BranchType.get(byteBuffer.get());
    }

    @Override
    public AbstractTransactionResponse handle(RpcContext rpcContext) {
        return this.handler.handle(this, rpcContext);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("xid=");
        result.append(this.xid);
        result.append(",");
        result.append("branchId=");
        result.append(this.branchId);
        result.append(",");
        result.append("resourceId=");
        result.append(this.resourceId);
        result.append(",");
        result.append("status=");
        result.append((Object)this.status);
        result.append(",");
        result.append("applicationData=");
        result.append(this.applicationData);
        return result.toString();
    }
}

