/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol;

import io.netty.buffer.ByteBuf;
import io.seata.core.protocol.AbstractIdentifyRequest;
import java.io.Serializable;

public class RegisterRMRequest
extends AbstractIdentifyRequest
implements Serializable {
    private static final long serialVersionUID = 7539732523682335742L;
    private String resourceIds;

    public RegisterRMRequest() {
        this(null, null);
    }

    public RegisterRMRequest(String applicationId, String transactionServiceGroup) {
        super(applicationId, transactionServiceGroup);
    }

    public String getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(String resourceIds) {
        this.resourceIds = resourceIds;
    }

    @Override
    public short getTypeCode() {
        return 103;
    }

    @Override
    protected void doEncode() {
        super.doEncode();
        if (this.resourceIds != null) {
            byte[] bs = this.resourceIds.getBytes(UTF8);
            this.byteBuffer.putInt(bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putInt(0);
        }
    }

    @Override
    public boolean decode(ByteBuf in) {
        if (in.readableBytes() < 2) {
            return false;
        }
        short len = in.readShort();
        if (len > 0) {
            if (in.readableBytes() < len) {
                return false;
            }
        } else {
            return false;
        }
        byte[] bs = new byte[len];
        in.readBytes(bs);
        this.setVersion(new String(bs, UTF8));
        if (in.readableBytes() < 2) {
            return false;
        }
        len = in.readShort();
        if (len > 0) {
            if (in.readableBytes() < len) {
                return false;
            }
            bs = new byte[len];
            in.readBytes(bs);
            this.setApplicationId(new String(bs, UTF8));
        }
        if (in.readableBytes() < 2) {
            return false;
        }
        len = in.readShort();
        if (in.readableBytes() < len) {
            return false;
        }
        bs = new byte[len];
        in.readBytes(bs);
        this.setTransactionServiceGroup(new String(bs, UTF8));
        if (in.readableBytes() < 2) {
            return false;
        }
        len = in.readShort();
        if (len > 0) {
            if (in.readableBytes() < len) {
                return false;
            }
            bs = new byte[len];
            in.readBytes(bs);
            this.setExtraData(new String(bs, UTF8));
        }
        if (in.readableBytes() < 4) {
            return false;
        }
        int iLen = in.readInt();
        if (iLen > 0) {
            if (in.readableBytes() < iLen) {
                return false;
            }
            bs = new byte[iLen];
            in.readBytes(bs);
            this.setResourceIds(new String(bs, UTF8));
            return true;
        }
        return true;
    }

    public String toString() {
        return "RegisterRMRequest{resourceIds='" + this.resourceIds + '\'' + ", applicationId='" + this.applicationId + '\'' + ", transactionServiceGroup='" + this.transactionServiceGroup + '\'' + '}';
    }
}

