/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol;

import io.netty.buffer.ByteBuf;
import io.seata.core.protocol.AbstractMessage;
import io.seata.core.protocol.AbstractResultMessage;
import io.seata.core.protocol.MergeMessage;
import io.seata.core.protocol.MergedMessage;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeResultMessage
extends AbstractMessage
implements MergeMessage {
    private static final long serialVersionUID = -7719219648774528552L;
    public AbstractResultMessage[] msgs;
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeResultMessage.class);

    public AbstractResultMessage[] getMsgs() {
        return this.msgs;
    }

    public void setMsgs(AbstractResultMessage[] msgs) {
        this.msgs = msgs;
    }

    @Override
    public short getTypeCode() {
        return 60;
    }

    @Override
    public byte[] encode() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.msgs.length * 1024);
        byteBuffer.putShort((short)this.msgs.length);
        for (AbstractResultMessage msg : this.msgs) {
            byte[] data = msg.encode();
            byteBuffer.putShort(msg.getTypeCode());
            byteBuffer.put(data);
        }
        byteBuffer.flip();
        int length = byteBuffer.limit();
        byte[] content = new byte[length + 4];
        MergeResultMessage.intToBytes(length, content, 0);
        byteBuffer.get(content, 4, length);
        if (this.msgs.length > 20 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("msg in one services merge packet:" + this.msgs.length + ",buffer size:" + content.length);
        }
        return content;
    }

    @Override
    public boolean decode(ByteBuf in) {
        if (in.readableBytes() < 4) {
            return false;
        }
        int length = in.readInt();
        if (in.readableBytes() < length) {
            return false;
        }
        byte[] buffer = new byte[length];
        in.readBytes(buffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        this.decode(byteBuffer);
        return true;
    }

    public void decode(ByteBuffer byteBuffer) {
        int msgNum = byteBuffer.getShort();
        this.msgs = new AbstractResultMessage[msgNum];
        for (int idx = 0; idx < msgNum; ++idx) {
            short typeCode = byteBuffer.getShort();
            MergedMessage message = MergeResultMessage.getMergeResponseInstanceByCode(typeCode);
            message.decode(byteBuffer);
            this.msgs[idx] = (AbstractResultMessage)message;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MergeResultMessage ");
        if (this.msgs == null) {
            return sb.toString();
        }
        for (AbstractResultMessage msg : this.msgs) {
            sb.append(msg.toString()).append("\n");
        }
        return sb.toString();
    }
}

