/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.MySqlColumnMetadata;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.server.FieldReader;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.NettyBufferUtils;
import io.netty.util.ReferenceCounted;

public final class RowMessage
implements ReferenceCounted,
ServerMessage {
    static final short NULL_VALUE = 251;
    private static final byte BIT_MASK_INIT = 4;
    private final FieldReader reader;

    RowMessage(FieldReader reader) {
        this.reader = AssertUtils.requireNonNull(reader, "reader must not be null");
    }

    public FieldValue[] decode(boolean isBinary, MySqlColumnMetadata[] context) {
        return isBinary ? this.binary(context) : this.text(context.length);
    }

    private FieldValue[] text(int size) {
        FieldValue[] fields = new FieldValue[size];
        try {
            for (int i = 0; i < size; ++i) {
                if (251 == this.reader.getUnsignedByte()) {
                    this.reader.skipOneByte();
                    fields[i] = FieldValue.nullField();
                    continue;
                }
                fields[i] = this.reader.readVarIntSizedField();
            }
            return fields;
        }
        catch (Throwable e) {
            NettyBufferUtils.releaseAll(fields, size);
            throw e;
        }
    }

    private FieldValue[] binary(MySqlColumnMetadata[] context) {
        this.reader.skipOneByte();
        int size = context.length;
        byte[] nullBitmap = this.reader.readSizeFixedBytes(size + 9 >> 3);
        int bitmapIndex = 0;
        int bitMask = 4;
        FieldValue[] fields = new FieldValue[size];
        try {
            for (int i = 0; i < size; ++i) {
                int bytes;
                fields[i] = (nullBitmap[bitmapIndex] & bitMask) != 0 ? FieldValue.nullField() : ((bytes = context[i].getType().getBinarySize()) > 0 ? this.reader.readSizeFixedField(bytes) : this.reader.readVarIntSizedField());
                if (((bitMask = (int)((byte)(bitMask << 1))) & 0xFF) != 0) continue;
                bitMask = 1;
                ++bitmapIndex;
            }
            return fields;
        }
        catch (Throwable e) {
            NettyBufferUtils.releaseAll(fields, size);
            throw e;
        }
    }

    public int refCnt() {
        return this.reader.refCnt();
    }

    public RowMessage retain() {
        this.reader.retain();
        return this;
    }

    public RowMessage retain(int increment) {
        this.reader.retain(increment);
        return this;
    }

    public RowMessage touch() {
        this.reader.touch();
        return this;
    }

    public RowMessage touch(Object o) {
        this.reader.touch(o);
        return this;
    }

    public boolean release() {
        return this.reader.release();
    }

    public boolean release(int decrement) {
        return this.reader.release(decrement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowMessage)) {
            return false;
        }
        RowMessage that = (RowMessage)o;
        return this.reader.equals(that.reader);
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    public String toString() {
        return "RowMessage(encoded)";
    }
}

