/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.message.server.WarningMessage;
import io.netty.buffer.ByteBuf;

public final class PreparedOkMessage
implements ServerMessage,
WarningMessage {
    private static final int MIN_SIZE = 10;
    private static final int WARNING_SIZE = 12;
    private final int statementId;
    private final int totalColumns;
    private final int totalParameters;
    private final int warnings;

    private PreparedOkMessage(int statementId, int totalColumns, int totalParameters, int warnings) {
        this.statementId = statementId;
        this.totalColumns = totalColumns;
        this.totalParameters = totalParameters;
        this.warnings = warnings;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public int getTotalColumns() {
        return this.totalColumns;
    }

    public int getTotalParameters() {
        return this.totalParameters;
    }

    @Override
    public int getWarnings() {
        return this.warnings;
    }

    static boolean isLooksLike(ByteBuf buf) {
        int readerIndex = buf.readerIndex();
        int readableBytes = buf.readableBytes();
        return (readableBytes == 10 || readableBytes == 12) && buf.getByte(readerIndex) == 0 && buf.getByte(readerIndex + 9) == 0;
    }

    static PreparedOkMessage decode(ByteBuf buf) {
        buf.skipBytes(1);
        int statementId = buf.readIntLE();
        int totalColumns = buf.readUnsignedShortLE();
        int totalParameters = buf.readUnsignedShortLE();
        buf.skipBytes(1);
        int warnings = buf.isReadable(2) ? buf.readUnsignedShortLE() : 0;
        return new PreparedOkMessage(statementId, totalColumns, totalParameters, warnings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PreparedOkMessage)) {
            return false;
        }
        PreparedOkMessage that = (PreparedOkMessage)o;
        return this.statementId == that.statementId && this.totalColumns == that.totalColumns && this.totalParameters == that.totalParameters && this.warnings == that.warnings;
    }

    public int hashCode() {
        int result = this.statementId;
        result = 31 * result + this.totalColumns;
        result = 31 * result + this.totalParameters;
        return 31 * result + this.warnings;
    }

    public String toString() {
        if (this.warnings == 0) {
            return "PreparedOkMessage{statementId=" + this.statementId + ", totalColumns=" + this.totalColumns + ", totalParameters=" + this.totalParameters + '}';
        }
        return "PreparedOkMessage{statementId=" + this.statementId + ", totalColumns=" + this.totalColumns + ", totalParameters=" + this.totalParameters + ", warnings=" + this.warnings + '}';
    }
}

