/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.Capability;
import dev.miku.r2dbc.mysql.message.server.HandshakeHeader;
import dev.miku.r2dbc.mysql.message.server.HandshakeV10Request;
import dev.miku.r2dbc.mysql.message.server.HandshakeV9Request;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcPermissionDeniedException;

public interface HandshakeRequest
extends ServerMessage {
    public HandshakeHeader getHeader();

    public int getEnvelopeId();

    public Capability getServerCapability();

    public String getAuthType();

    public byte[] getSalt();

    public static HandshakeRequest decode(int envelopeId, ByteBuf buf) {
        HandshakeHeader header = HandshakeHeader.decode(buf);
        short version = header.getProtocolVersion();
        switch (version) {
            case 10: {
                return HandshakeV10Request.decode(envelopeId, buf, header);
            }
            case 9: {
                return HandshakeV9Request.decode(envelopeId, buf, header);
            }
        }
        throw new R2dbcPermissionDeniedException("Does not support handshake protocol version " + version);
    }
}

