/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.server.ByteBufCombiner;
import dev.miku.r2dbc.mysql.message.server.LargeFieldReader;
import dev.miku.r2dbc.mysql.message.server.NormalFieldReader;
import dev.miku.r2dbc.mysql.util.NettyBufferUtils;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import java.util.List;

interface FieldReader
extends ReferenceCounted {
    public short getUnsignedByte();

    public void skipOneByte();

    public byte[] readSizeFixedBytes(int var1);

    public FieldValue readSizeFixedField(int var1);

    public FieldValue readVarIntSizedField();

    public static FieldReader of(List<ByteBuf> buffers) {
        int size = buffers.size();
        long totalSize = 0L;
        try {
            for (int i = 0; i < size && (totalSize += (long)buffers.get(i).readableBytes()) <= Integer.MAX_VALUE; ++i) {
            }
        }
        catch (Throwable e) {
            NettyBufferUtils.releaseAll(buffers, size);
            buffers.clear();
            throw e;
        }
        if (totalSize <= Integer.MAX_VALUE) {
            ByteBuf combined = ByteBufCombiner.composite(buffers);
            try {
                return new NormalFieldReader(combined);
            }
            catch (Throwable e) {
                combined.release();
                throw e;
            }
        }
        try {
            LargeFieldReader combined = new LargeFieldReader(buffers.toArray(new ByteBuf[0]));
            return combined;
        }
        catch (Throwable e) {
            NettyBufferUtils.releaseAll(buffers, size);
            throw e;
        }
        finally {
            buffers.clear();
        }
    }
}

