/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.Query;
import dev.miku.r2dbc.mysql.message.client.ClientMessage;
import dev.miku.r2dbc.mysql.message.client.ParamWriter;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PreparedTextQueryMessage
extends AtomicReference<Parameter[]>
implements ClientMessage,
Disposable {
    private final Query query;

    public PreparedTextQueryMessage(Query query, Parameter[] values) {
        super(AssertUtils.requireNonNull(values, "values must not be null"));
        this.query = AssertUtils.requireNonNull(query, "query must not be null");
    }

    public void dispose() {
        Parameter[] values;
        for (Parameter value : values = (Parameter[])this.getAndSet(null)) {
            if (value == null) continue;
            value.dispose();
        }
    }

    public boolean isDisposed() {
        return this.get() == null;
    }

    public Mono<ByteBuf> encode(ByteBufAllocator allocator, ConnectionContext context) {
        AssertUtils.requireNonNull(allocator, "allocator must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        Charset charset = context.getClientCollation().getCharset();
        Flux parameters = Flux.defer(() -> {
            Object[] values = this.getAndSet(null);
            if (values == null) {
                return Flux.error((Throwable)new IllegalStateException("Parameters have been disposed"));
            }
            return Flux.fromArray((Object[])values);
        });
        return ParamWriter.publish(this.query, (Flux<Parameter>)parameters).map(it -> {
            ByteBuf buf = allocator.buffer();
            try {
                buf.writeByte(3).writeCharSequence((CharSequence)it, charset);
                return buf;
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
        });
    }

    @Override
    public String toString() {
        return "PreparedTextQueryMessage{sql=REDACTED}";
    }
}

