/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.MySqlColumnMetadata;
import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.ByteCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.CodecUtils;
import dev.miku.r2dbc.mysql.codec.IntegerCodec;
import dev.miku.r2dbc.mysql.codec.ShortCodec;
import dev.miku.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.Year;

final class YearCodec
extends AbstractClassedCodec<Year> {
    YearCodec(ByteBufAllocator allocator) {
        super(allocator, Year.class);
    }

    @Override
    public Year decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return binary ? Year.of(value.readShortLE()) : Year.of(CodecUtils.parseInt(value));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Year;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        int year = ((Year)value).getValue();
        if ((byte)year == year) {
            return new ByteCodec.ByteParameter(this.allocator, (byte)year);
        }
        if ((short)year == year) {
            return new ShortCodec.ShortParameter(this.allocator, (short)year);
        }
        return new IntegerCodec.IntParameter(this.allocator, year);
    }

    @Override
    public boolean doCanDecode(MySqlColumnMetadata metadata) {
        return metadata.getType() == MySqlType.YEAR;
    }
}

