/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.MySqlColumnMetadata;
import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.ByteCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.IntegerCodec;
import dev.miku.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import reactor.core.publisher.Mono;

final class ShortCodec
extends AbstractPrimitiveCodec<Short> {
    ShortCodec(ByteBufAllocator allocator) {
        super(allocator, Short.TYPE, Short.class);
    }

    @Override
    public Short decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return (short)IntegerCodec.decodeInt(value, binary, metadata.getType());
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Short;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        short v = (Short)value;
        if ((byte)v == v) {
            return new ByteCodec.ByteParameter(this.allocator, (byte)v);
        }
        return new ShortParameter(this.allocator, v);
    }

    @Override
    public boolean canPrimitiveDecode(MySqlColumnMetadata metadata) {
        return metadata.getType().isNumeric();
    }

    static final class ShortParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final short value;

        ShortParameter(ByteBufAllocator allocator, short value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> this.allocator.buffer(2).writeShortLE((int)this.value));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeInt(this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.SMALLINT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ShortParameter)) {
                return false;
            }
            ShortParameter that = (ShortParameter)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

