/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.MySqlColumnMetadata;
import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.Codec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.DateTimes;
import dev.miku.r2dbc.mysql.codec.LocalDateTimeCodec;
import dev.miku.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import reactor.core.publisher.Mono;

final class OffsetDateTimeCodec
implements Codec<OffsetDateTime> {
    private final ByteBufAllocator allocator;

    OffsetDateTimeCodec(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public OffsetDateTime decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        LocalDateTime origin = LocalDateTimeCodec.decodeOrigin(value, binary, context);
        if (origin == null) {
            return null;
        }
        ZoneId zone = context.getServerZoneId();
        return OffsetDateTime.of(origin, zone instanceof ZoneOffset ? (ZoneOffset)zone : zone.getRules().getOffset(origin));
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new OffsetDateTimeParameter(this.allocator, (OffsetDateTime)value, context);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof OffsetDateTime;
    }

    @Override
    public boolean canDecode(MySqlColumnMetadata metadata, Class<?> target) {
        return DateTimes.canDecodeDateTime(metadata.getType(), target, OffsetDateTime.class);
    }

    private static final class OffsetDateTimeParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final OffsetDateTime value;
        private final CodecContext context;

        private OffsetDateTimeParameter(ByteBufAllocator allocator, OffsetDateTime value, CodecContext context) {
            this.allocator = allocator;
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> LocalDateTimeCodec.encodeBinary(this.allocator, this.serverValue()));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> LocalDateTimeCodec.encodeText(writer, this.serverValue()));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.TIMESTAMP;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OffsetDateTimeParameter that = (OffsetDateTimeParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        private LocalDateTime serverValue() {
            ZoneId zone = this.context.getServerZoneId();
            return zone instanceof ZoneOffset ? this.value.withOffsetSameInstant((ZoneOffset)zone).toLocalDateTime() : this.value.toZonedDateTime().withZoneSameInstant(zone).toLocalDateTime();
        }
    }
}

