/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.MySqlColumnMetadata;
import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.ByteCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.CodecUtils;
import dev.miku.r2dbc.mysql.codec.ShortCodec;
import dev.miku.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class IntegerCodec
extends AbstractPrimitiveCodec<Integer> {
    IntegerCodec(ByteBufAllocator allocator) {
        super(allocator, Integer.TYPE, Integer.class);
    }

    @Override
    public Integer decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return IntegerCodec.decodeInt(value, binary, metadata.getType());
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Integer;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        int v = (Integer)value;
        if ((byte)v == v) {
            return new ByteCodec.ByteParameter(this.allocator, (byte)v);
        }
        if ((short)v == v) {
            return new ShortCodec.ShortParameter(this.allocator, (short)v);
        }
        return new IntParameter(this.allocator, v);
    }

    @Override
    public boolean canPrimitiveDecode(MySqlColumnMetadata metadata) {
        return metadata.getType().isNumeric();
    }

    static int decodeInt(ByteBuf buf, boolean binary, MySqlType type) {
        if (binary) {
            return IntegerCodec.decodeBinary(buf, type);
        }
        switch (type) {
            case FLOAT: {
                return (int)Float.parseFloat(buf.toString(StandardCharsets.US_ASCII));
            }
            case DOUBLE: {
                return (int)Double.parseDouble(buf.toString(StandardCharsets.US_ASCII));
            }
            case DECIMAL: {
                return IntegerCodec.decimalInt(buf);
            }
        }
        return CodecUtils.parseInt(buf);
    }

    private static int decodeBinary(ByteBuf buf, MySqlType type) {
        switch (type) {
            case BIGINT_UNSIGNED: 
            case BIGINT: 
            case INT_UNSIGNED: 
            case INT: 
            case MEDIUMINT_UNSIGNED: 
            case MEDIUMINT: {
                return buf.readIntLE();
            }
            case SMALLINT_UNSIGNED: {
                return buf.readUnsignedShortLE();
            }
            case SMALLINT: 
            case YEAR: {
                return buf.readShortLE();
            }
            case TINYINT_UNSIGNED: {
                return buf.readUnsignedByte();
            }
            case TINYINT: {
                return buf.readByte();
            }
            case DECIMAL: {
                return IntegerCodec.decimalInt(buf);
            }
            case FLOAT: {
                return (int)buf.readFloatLE();
            }
            case DOUBLE: {
                return (int)buf.readDoubleLE();
            }
        }
        throw new IllegalStateException("Cannot decode type " + (Object)((Object)type) + " as an Integer");
    }

    private static int decimalInt(ByteBuf buf) {
        return new BigDecimal(buf.toString(StandardCharsets.US_ASCII)).intValue();
    }

    static final class IntParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final int value;

        IntParameter(ByteBufAllocator allocator, int value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> this.allocator.buffer(4).writeIntLE(this.value));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeInt(this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.INT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntParameter)) {
                return false;
            }
            IntParameter intValue = (IntParameter)o;
            return this.value == intValue.value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

