/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.MySqlColumnMetadata;
import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.CodecUtils;
import dev.miku.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class FloatCodec
extends AbstractPrimitiveCodec<Float> {
    FloatCodec(ByteBufAllocator allocator) {
        super(allocator, Float.TYPE, Float.class);
    }

    @Override
    public Float decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        MySqlType type = metadata.getType();
        if (binary) {
            return Float.valueOf(FloatCodec.decodeBinary(value, type));
        }
        switch (metadata.getType()) {
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case BIGINT_UNSIGNED: {
                return Float.valueOf(Float.parseFloat(value.toString(StandardCharsets.US_ASCII)));
            }
        }
        return Float.valueOf(CodecUtils.parseLong(value));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Float;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new FloatParameter(this.allocator, ((Float)value).floatValue());
    }

    @Override
    public boolean canPrimitiveDecode(MySqlColumnMetadata metadata) {
        return metadata.getType().isNumeric();
    }

    private static float decodeBinary(ByteBuf buf, MySqlType type) {
        switch (type) {
            case BIGINT_UNSIGNED: {
                long v = buf.readLongLE();
                if (v < 0L) {
                    return CodecUtils.unsignedBigInteger(v).floatValue();
                }
                return v;
            }
            case BIGINT: {
                return buf.readLongLE();
            }
            case INT_UNSIGNED: {
                return buf.readUnsignedIntLE();
            }
            case INT: 
            case MEDIUMINT_UNSIGNED: 
            case MEDIUMINT: {
                return buf.readIntLE();
            }
            case SMALLINT_UNSIGNED: {
                return buf.readUnsignedShortLE();
            }
            case SMALLINT: 
            case YEAR: {
                return buf.readShortLE();
            }
            case TINYINT_UNSIGNED: {
                return buf.readUnsignedByte();
            }
            case TINYINT: {
                return buf.readByte();
            }
            case DECIMAL: {
                return Float.parseFloat(buf.toString(StandardCharsets.US_ASCII));
            }
            case FLOAT: {
                return buf.readFloatLE();
            }
            case DOUBLE: {
                return (float)buf.readDoubleLE();
            }
        }
        throw new IllegalStateException("Cannot decode type " + (Object)((Object)type) + " as a Float");
    }

    private static final class FloatParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final float value;

        private FloatParameter(ByteBufAllocator allocator, float value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> {
                ByteBuf buf = this.allocator.buffer(4);
                try {
                    return buf.writeFloatLE(this.value);
                }
                catch (Throwable e) {
                    buf.release();
                    throw e;
                }
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeFloat(this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.FLOAT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FloatParameter)) {
                return false;
            }
            FloatParameter that = (FloatParameter)o;
            return Float.compare(that.value, this.value) == 0;
        }

        public int hashCode() {
            return this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
        }
    }
}

