/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.MySqlColumnMetadata;
import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.Codec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.StringCodec;
import dev.miku.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import reactor.core.publisher.Mono;

final class EnumCodec
implements Codec<Enum<?>> {
    private final ByteBufAllocator allocator;

    EnumCodec(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public Enum<?> decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        Charset charset = metadata.getCharCollation(context).getCharset();
        return Enum.valueOf(target, value.toString(charset));
    }

    @Override
    public boolean canDecode(MySqlColumnMetadata metadata, Class<?> target) {
        return metadata.getType() == MySqlType.ENUM && target.isEnum();
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Enum;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new EnumParameter(this.allocator, (Enum)value, context);
    }

    private static final class EnumParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final Enum<?> value;
        private final CodecContext context;

        private EnumParameter(ByteBufAllocator allocator, Enum<?> value, CodecContext context) {
            this.allocator = allocator;
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> StringCodec.encodeCharSequence(this.allocator, this.value.name(), this.context));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.write(this.value.name()));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.VARCHAR;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EnumParameter)) {
                return false;
            }
            EnumParameter enumValue = (EnumParameter)o;
            return this.value.equals(enumValue.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

